package blanco.plugin.csv.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.csv.BlancoCsvConstants;
import blanco.csv.BlancoCsvDotNetMeta2Xml;
import blanco.csv.BlancoCsvMeta2Xml;
import blanco.csv.BlancoCsvXml2CsClass;
import blanco.csv.BlancoCsvXml2JavaClass;
import blanco.csv.resourcebundle.BlancoCsvResourceBundle;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlCsv;
import blanco.plugin.csv.BlancoCsvPlugin;
import blanco.plugin.csv.BlancoCsvPluginConstants;
import blanco.plugin.csv.editors.BlancoCsvPluginUtil;

public class BlancoCsvGenerateAction {
    private static final BlancoCsvResourceBundle fBundle = new BlancoCsvResourceBundle();

    /**
     * blancoCsv Java\[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param runtimePackage
     *            ^CpbP[WBwnullŕ\B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoCsvJavaSource(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String runtimePackage, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            // Eclipse vOC̏̃[ɏ]Ď\[XR[h̕GR[fBOB
            final String encoding = ifile.getProject().getDefaultCharset(true);

            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoCsvConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoCsvPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                BlancoCsvPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                BlancoCsvPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY
                                                        + BlancoCsvConstants.VALUE_OBJECT_DIRECTORY);
                                final IFolder tempFolder = BlancoCsvPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempValueObjectFolder = BlancoCsvPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY
                                                        + BlancoCsvConstants.VALUE_OBJECT_DIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoCsvPluginUtil
                                        .findFolder(ifile, monitor, metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                new BlancoCsvMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoCsvPluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                monitor.subTask("tH_쐬: blancotH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: blanco/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask("Java\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("Java\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            final BlancoCsvXml2JavaClass xml2java = new BlancoCsvXml2JavaClass();
                                            xml2java.setEncoding(encoding);
                                            xml2java.process(fileLook
                                                    .getLocation().toFile(),
                                                    runtimePackage,
                                                    tempValueObjectFolder
                                                            .getLocation()
                                                            .toFile(),
                                                    blancoTargetDirectory);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoCsvPluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: blancotH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoCsvPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoCsvPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoCsvPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoCsvPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoCsvPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * blancoCsv C#.NET\[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param runtimePackage
     *            ^CpbP[WBwnullŕ\B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoCsvCsSource(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String runtimePackage, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            // Eclipse vOC̏̃[ɏ]Ď\[XR[h̕GR[fBOB
            final String encoding = ifile.getProject().getDefaultCharset(true);

            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoCsvConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoCsvPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                BlancoCsvPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                BlancoCsvPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY
                                                        + BlancoCsvConstants.VALUE_OBJECT_DIRECTORY);
                                final IFolder tempFolder = BlancoCsvPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempValueObjectFolder = BlancoCsvPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoCsvConstants.TARGET_SUBDIRECTORY
                                                        + BlancoCsvConstants.VALUE_OBJECT_DIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoCsvPluginUtil
                                        .findFolder(ifile, monitor, metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                new BlancoCsvDotNetMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoCsvPluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                monitor.subTask("tH_쐬: blanco.cstH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco.cs");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: blanco.cs/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask("C#.NET\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("C#.NET\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            final BlancoCsvXml2CsClass xml2cs = new BlancoCsvXml2CsClass();
                                            xml2cs.setEncoding(encoding);
                                            xml2cs.process(fileLook
                                                    .getLocation().toFile(),
                                                    runtimePackage,
                                                    tempValueObjectFolder
                                                            .getLocation()
                                                            .toFile(),
                                                    blancoTargetDirectory);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoCsvPluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: blanco.cstH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoCsvPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoCsvPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoCsvPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoCsvPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoCsvPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}