/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;
import blanco.csv.resourcebundle.BlancoCsvIOExceptionResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructure;

public class BlancoCsvExpandIOException {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    private final BlancoCsvIOExceptionResourceBundle bundle = new BlancoCsvIOExceptionResourceBundle();

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructure processStructure,
            final File directoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getRuntimePackage()
                + bundle.getPackagePrefix(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        fCgClass = fCgFactory.createClass(bundle.getClassName(),
                BlancoStringUtil.null2Blank(bundle.getClasscomment01()));
        fCgSourceFile.getClassList().add(fCgClass);
        fCgClass.getExtendClassList().add(
                fCgFactory.createType(bundle.getSuperclassName()));
        fCgClass.getLangDoc().getDescriptionList().add(
                bundle.getClasscomment02());

        // VAIĎx}B
        fCgClass.getAnnotationList().add("SuppressWarnings(\"serial\")");

        {
            final BlancoCgMethod method = fCgFactory.createMethod(bundle
                    .getClassName(), "bZ[W𔺂blancoCsvONX𐶐܂B");
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);
            method.getParameterList().add(
                    fCgFactory.createParameter("message", bundle
                            .getConstructor01Arg01Type(), "bZ[WB"));
            method.getLineList().add(bundle.getConstructor01Line01());
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(bundle
                    .getClassName(), "bZ[Wь𔺂blancoCsvONX𐶐܂B");
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);
            method.getParameterList().add(
                    fCgFactory.createParameter("message", bundle
                            .getConstructor01Arg01Type(), "bZ[WB"));
            method.getParameterList().add(
                    fCgFactory.createParameter("argCause",
                            "java.lang.Throwable", "ƂȂOIuWFNgB"));
            method.getLineList().add("super(message, argCause);");
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
