/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringconverter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.stringconverter.message.BlancoStringConverterMessage;
import blanco.stringconverter.valueobject.BlancoStringConverterFieldStructure;
import blanco.stringconverter.valueobject.BlancoStringConverterStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringConverterXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoStringConverterMessage fMsg = new BlancoStringConverterMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoStringConverterStructure[] parse(
            final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoStringConverterStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final List<BlancoStringConverterStructure> listStructure = new ArrayList<BlancoStringConverterStructure>();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final BlancoStringConverterStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoStringConverterStructure[] result = new BlancoStringConverterStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoStringConverterStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoStringConverterStructure structure = new BlancoStringConverterStructure();
        // ̓p[^擾܂B

        final List<BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                .getElementsByTagName(argElementSheet,
                        "blancostringconverter-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = listCommon.get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "package"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbsci001(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "suffix"));
        }

        final BlancoXmlElement elementStringGroupList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancostringconverter-list");
        if (elementStringGroupList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                .getElementsByTagName(elementStringGroupList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final BlancoXmlElement elementField = listField.get(indexField);

            final BlancoStringConverterFieldStructure fieldStructure = new BlancoStringConverterFieldStructure();

            fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            fieldStructure.setFrom(BlancoXmlBindingUtil.getTextContent(
                    elementField, "from"));
            if (BlancoStringUtil.null2Blank(fieldStructure.getFrom()).length() == 0) {
                // fromw肳ĂȂꍇɂ͏܂B
                continue;
            }

            fieldStructure.setTo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "to"));
            if (BlancoStringUtil.null2Blank(fieldStructure.getTo()).length() == 0) {
                // tow肳ĂȂꍇɂ͏܂B
                continue;
            }

            fieldStructure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementField, "description"));

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getFieldList().size(); indexPast++) {
                final BlancoStringConverterFieldStructure fieldPast = (BlancoStringConverterFieldStructure) structure
                        .getFieldList().get(indexPast);
                if (fieldPast.getFrom().equals(fieldStructure.getFrom())) {
                    throw new IllegalArgumentException(fMsg.getMbsci003(
                            structure.getName(), fieldStructure.getFrom()));
                }
            }

            structure.getFieldList().add(fieldStructure);
        }

        return structure;
    }
}
