/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.db.common.stringgroup;

/**
 * JDBChCöꗗB
 */
public class BlancoDbDriverNameStringGroup {
    /**
     * No.1 :SQL Server 2000pJDBChCo
     */
    public static final int SQLSERVER_2000 = 1;

    /**
     * No.2 :SQL Server 2005pJDBChCoBSQL Server 2000ɂڑ\B
     */
    public static final int SQLSERVER_2005 = 2;

    /**
     * No.3 :SQL Server 2008pJDBChCoB
     */
    public static final int SQLSERVER_2008 = 3;

    /**
     * No.4 :OraclepJDBChCoB
     */
    public static final int ORACLE = 4;

    /**
     * No.5 :PostgreSQLpJDBChCoB
     */
    public static final int POSTGRESQL = 5;

    /**
     * No.6 :MySQLpJDBChCoB
     */
    public static final int MYSQL = 6;

    /**
     * `BO[vȊO̕܂͒萔`̂́B
     */
    public static final int NOT_DEFINED = -1;

    /**
     * O[vɊ܂܂镶ł邩ǂ𔻒肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean match(final String argCheck) {
        // No.1
        // :SQL Server 2000pJDBChCo
        if ("SQLServer".equals(argCheck)) {
            return true;
        }
        // No.2
        // :SQL Server 2005pJDBChCoBSQL Server 2000ɂڑ\B
        if ("Microsoft SQL Server 2005 JDBC Driver".equals(argCheck)) {
            return true;
        }
        // No.3
        // :SQL Server 2008pJDBChCoB
        if ("Microsoft SQL Server JDBC Driver 2.0".equals(argCheck)) {
            return true;
        }
        // No.4
        // :OraclepJDBChCoB
        if ("Oracle JDBC driver".equals(argCheck)) {
            return true;
        }
        // No.5
        // :PostgreSQLpJDBChCoB
        if ("PostgreSQL Native Driver".equals(argCheck)) {
            return true;
        }
        // No.6
        // :MySQLpJDBChCoB
        if ("MySQL-AB JDBC Driver".equals(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B
     *
     * @param argCheck `FbNsB
     * @return O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB
     */
    public boolean matchIgnoreCase(final String argCheck) {
        // No.1
        // :SQL Server 2000pJDBChCo
        if ("SQLServer".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.2
        // :SQL Server 2005pJDBChCoBSQL Server 2000ɂڑ\B
        if ("Microsoft SQL Server 2005 JDBC Driver".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.3
        // :SQL Server 2008pJDBChCoB
        if ("Microsoft SQL Server JDBC Driver 2.0".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.4
        // :OraclepJDBChCoB
        if ("Oracle JDBC driver".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.5
        // :PostgreSQLpJDBChCoB
        if ("PostgreSQL Native Driver".equalsIgnoreCase(argCheck)) {
            return true;
        }
        // No.6
        // :MySQLpJDBChCoB
        if ("MySQL-AB JDBC Driver".equalsIgnoreCase(argCheck)) {
            return true;
        }
        return false;
    }

    /**
     * 񂩂萔ɕϊ܂B
     *
     * 萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B
     *
     * @param argCheck ϊsB
     * @return 萔ɕϊ̒lB
     */
    public int convertToInt(final String argCheck) {
        // No.1
        // :SQL Server 2000pJDBChCo
        if ("SQLServer".equals(argCheck)) {
            return SQLSERVER_2000;
        }
        // No.2
        // :SQL Server 2005pJDBChCoBSQL Server 2000ɂڑ\B
        if ("Microsoft SQL Server 2005 JDBC Driver".equals(argCheck)) {
            return SQLSERVER_2005;
        }
        // No.3
        // :SQL Server 2008pJDBChCoB
        if ("Microsoft SQL Server JDBC Driver 2.0".equals(argCheck)) {
            return SQLSERVER_2008;
        }
        // No.4
        // :OraclepJDBChCoB
        if ("Oracle JDBC driver".equals(argCheck)) {
            return ORACLE;
        }
        // No.5
        // :PostgreSQLpJDBChCoB
        if ("PostgreSQL Native Driver".equals(argCheck)) {
            return POSTGRESQL;
        }
        // No.6
        // :MySQLpJDBChCoB
        if ("MySQL-AB JDBC Driver".equals(argCheck)) {
            return MYSQL;
        }

        // Y萔܂łB
        return NOT_DEFINED;
    }

    /**
     * 萔當ɕϊ܂B
     *
     * 萔ƑΉÂɕϊ܂B
     *
     * @param argCheck ϊs萔B
     * @return ɕϊ̒lBNOT_DEFINED̏ꍇɂ͒0̕B
     */
    public String convertToString(final int argCheck) {
        // No.1
        // :SQL Server 2000pJDBChCo
        if (argCheck == SQLSERVER_2000) {
            return "SQLServer";
        }
        // No.2
        // :SQL Server 2005pJDBChCoBSQL Server 2000ɂڑ\B
        if (argCheck == SQLSERVER_2005) {
            return "Microsoft SQL Server 2005 JDBC Driver";
        }
        // No.3
        // :SQL Server 2008pJDBChCoB
        if (argCheck == SQLSERVER_2008) {
            return "Microsoft SQL Server JDBC Driver 2.0";
        }
        // No.4
        // :OraclepJDBChCoB
        if (argCheck == ORACLE) {
            return "Oracle JDBC driver";
        }
        // No.5
        // :PostgreSQLpJDBChCoB
        if (argCheck == POSTGRESQL) {
            return "PostgreSQL Native Driver";
        }
        // No.6
        // :MySQLpJDBChCoB
        if (argCheck == MYSQL) {
            return "MySQL-AB JDBC Driver";
        }
        // `B
        if (argCheck == NOT_DEFINED) {
            return "";
        }

        // ɂY܂łB
        throw new IllegalArgumentException("^ꂽl(" + argCheck + ")͕O[v[BlancoDbDriverName]ł͒`ȂlłB");
    }
}
