/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker.odp;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.exception.NoRowModifiedExceptionClassDotNet;
import blanco.db.expander.exception.TooManyRowsModifiedExceptionClassDotNet;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Tosiki Iga
 */
public class ExecuteSingleUpdateMethodOdpDotNet extends BlancoDbAbstractMethod {
    public ExecuteSingleUpdateMethodOdpDotNet(
            final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "ExecuteSingleUpdate", "s^NGs܂B");
        fCgClass.getMethodList().add(cgMethod);

        // cgMethod.getThrowList().add(
        // fCgFactory.createException(BlancoDbUtil
        // .getRuntimePackage(fDbSetting)
        // + ".exception.NoRowModifiedException",
        // "f[^x[X̏̌ʁA1sf[^ύXȂꍇB"));
        //
        // cgMethod.getThrowList().add(
        // fCgFactory.createException(BlancoDbUtil
        // .getRuntimePackage(fDbSetting)
        // + ".exception.TooManyRowsModifiedException",
        // "f[^x[X̏̌ʁA1s𒴂f[^ύXĂ܂ꍇB"));

        cgMethod.getLangDoc().getDescriptionList().add(
                "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B");
        cgMethod.getLangDoc().getDescriptionList().add("");

        // BlancoDbCgUtilDotNet.addExceptionToMethodIntegrityConstraintException(
        // fCgFactory, cgMethod, fDbSetting);
        // BlancoDbCgUtilDotNet.addExceptionToMethodDeadlockTimeoutException(
        // fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add("singleL");
        cgMethod.getLangDoc().getDescriptionList().add(
                "sʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        cgMethod.getLangDoc().getDescriptionList().add("hNX̗O܂B");

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        listLine.add("int result = 0;");
        listLine.add("result = ExecuteUpdate();");
        listLine.add("");

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting) + ".exception."
                        + NoRowModifiedExceptionClassDotNet.CLASS_NAME);
        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting) + ".exception."
                        + TooManyRowsModifiedExceptionClassDotNet.CLASS_NAME);

        listLine.add("if (result == 0) {");
        listLine.add("throw new "
                + NoRowModifiedExceptionClassDotNet.CLASS_NAME
                + "(\"sꌏύX܂łB\");");
        listLine.add("} else if (result > 1) {");
        listLine
                .add("String message = \"ꌏ𒴂sύXĂ܂܂Bê:\" + result;");
        listLine.add("throw new "
                + TooManyRowsModifiedExceptionClassDotNet.CLASS_NAME
                + "(message);");
        listLine.add("}");
    }
}