/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractClientAdapter
implements ISVNClientAdapter {
    public void setKeywords(File path, SVNKeywords keywords, boolean recurse) throws SVNClientException {
        this.propertySet(path, "svn:keywords", keywords.toString(), recurse);
    }

    public SVNKeywords addKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(true);
        }
        if (keywords.isId()) {
            currentKeywords.setId(true);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(true);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedBy(true);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(true);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    public SVNKeywords removeKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(false);
        }
        if (keywords.isId()) {
            currentKeywords.setId(false);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(false);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    public List getIgnoredPatterns(File path) throws SVNClientException {
        if (!path.isDirectory()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ISVNProperty pd = this.propertyGet(path, "svn:ignore");
        if (pd == null) {
            return list;
        }
        String patterns = pd.getValue();
        StringTokenizer st = new StringTokenizer(patterns, "\n\r");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry == null || entry.length() <= 0) continue;
            list.add(entry);
        }
        return list;
    }

    public ISVNLogMessage[] getLogMessages(File arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, SVNRevision.HEAD, revStart, revEnd, stopOnCopy, fetchChangePath, 0L, false);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, false, fetchChangePath, 0L, false);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, 0L, false);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(path);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            return this.getLogMessages(info.getCopyUrl(), SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
        }
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, SVNRevision.HEAD, revisionStart, revisionEnd, false, fetchChangePath, 0L, false);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        return this.getLogMessages(url, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    public ISVNLogMessage[] getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        SVNLogMessageCallback worker = new SVNLogMessageCallback();
        this.getLogMessages(path, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (ISVNLogMessageCallback)worker);
        return worker.getLogMessages();
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        SVNLogMessageCallback worker = new SVNLogMessageCallback();
        this.getLogMessages(url, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (ISVNLogMessageCallback)worker);
        return worker.getLogMessages();
    }

    public void setIgnoredPatterns(File path, List patterns) throws SVNClientException {
        if (!path.isDirectory()) {
            return;
        }
        String separator = System.getProperty("line.separator");
        StringBuffer value = new StringBuffer();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            value.append(String.valueOf(pattern) + separator);
        }
        this.propertySet(path, "svn:ignore", value.toString(), false);
    }

    public void addToIgnoredPatterns(File path, String pattern) throws SVNClientException {
        List patterns = this.getIgnoredPatterns(path);
        if (patterns == null) {
            return;
        }
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(pattern)) continue;
            return;
        }
        patterns.add(pattern);
        this.setIgnoredPatterns(path, patterns);
    }

    public SVNKeywords getKeywords(File path) throws SVNClientException {
        ISVNProperty prop = this.propertyGet(path, "svn:keywords");
        if (prop == null) {
            return new SVNKeywords();
        }
        String value = prop.getValue();
        return new SVNKeywords(value);
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
    }

    public boolean statusReturnsRemoteInfo() {
        return false;
    }

    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean Atomic) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    protected void notImplementedYet() throws SVNClientException {
        throw new SVNClientException("Not implemented yet");
    }

    public boolean canCommitAcrossWC() {
        return false;
    }

    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        SVNUrl parent;
        if (makeParents && (parent = url.getParent()) != null) {
            ISVNInfo info = null;
            try {
                info = this.getInfo(parent);
            }
            catch (SVNClientException sVNClientException) {}
            if (info == null) {
                this.mkdir(parent, makeParents, message);
            }
        }
        this.mkdir(url, message);
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public ISVNInfo getInfo(SVNUrl url) throws SVNClientException {
        return this.getInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, dryRun, false);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public ISVNProperty propertyGet(SVNUrl url, String propertyName) throws SVNClientException {
        return this.propertyGet(url, SVNRevision.HEAD, SVNRevision.HEAD, propertyName);
    }

    /*
     * Exception decompiling
     */
    public void diff(File[] paths, File outFile, boolean recurse) throws SVNClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 196->200)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createPatch(File[] paths, File relativeToPath, File outFile, boolean recurse) throws SVNClientException {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("svn", "patch");
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new SVNClientException(e);
        }
        this.diff(paths, tmpFile, recurse);
        this.stripPathsFromPatch(tmpFile, outFile, relativeToPath);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stripPathsFromPatch(File tmpFile, File outFile, File relativeToPath) throws SVNClientException {
        String relativeStr = null;
        if (relativeToPath != null) {
            try {
                relativeStr = relativeToPath.isDirectory() ? relativeToPath.getCanonicalPath() : relativeToPath.getParentFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                relativeStr = relativeToPath.isDirectory() ? relativeToPath.getAbsolutePath() : relativeToPath.getParentFile().getAbsolutePath();
            }
            relativeStr = String.valueOf(relativeStr) + "/";
            relativeStr = relativeStr.replace('\\', '/');
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(tmpFile);
                fos = new FileOutputStream(outFile);
                byte[] b = new byte[fis.available()];
                fis.read(b);
                if (relativeToPath != null) {
                    byte[] o = new String(b).replaceAll(relativeStr, "").getBytes();
                    fos.write(o);
                } else {
                    fos.write(b);
                }
            }
            catch (FileNotFoundException e) {
                throw new SVNClientException(e);
            }
            catch (IOException e) {
                throw new SVNClientException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (fis != null) {
            fis.close();
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fos == null) return;
        fos.close();
    }
}

