/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse;

import java.util.Random;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.AbstractGoogleAnalyticsParameters;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.EclipseUserAgent;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.GoogleAnalyticsEclipseMessages;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.IEclipseEnvironment;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.IEclipseUserAgent;
import org.tigris.subversion.subclipse.tools.usage.googleanalytics.eclipse.LinuxSystem;
import org.tigris.subversion.subclipse.tools.usage.internal.SubclipseToolsUsageActivator;
import org.tigris.subversion.subclipse.tools.usage.preferences.UsageReportPreferencesUtils;

public abstract class AbstractEclipseEnvironment
extends AbstractGoogleAnalyticsParameters
implements IEclipseEnvironment {
    private static final String SYSPROP_JAVA_VERSION = "java.version";
    private String screenResolution;
    private String screenColorDepth;
    private Random random = new Random();
    private IEclipsePreferences preferences;
    private String firstVisit;
    private String lastVisit;
    private String currentVisit;
    private long visitCount;
    protected IEclipseUserAgent eclipseUserAgent;

    public AbstractEclipseEnvironment(String accountName, String hostName, IEclipsePreferences preferences) {
        this(accountName, hostName, "0", preferences);
    }

    public AbstractEclipseEnvironment(String accountName, String hostName, String referral, IEclipsePreferences preferences) {
        super(accountName, hostName, referral);
        this.preferences = preferences;
        this.eclipseUserAgent = this.createEclipseUserAgent();
        this.initScreenSettings();
        this.initVisits();
    }

    protected void initScreenSettings() {
        final Display display = this.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                AbstractEclipseEnvironment.this.screenColorDepth = String.valueOf(display.getDepth()) + "-bit";
                Rectangle bounds = display.getBounds();
                AbstractEclipseEnvironment.this.screenResolution = String.valueOf(bounds.width) + "x" + bounds.height;
            }
        });
    }

    private void initVisits() {
        String currentTime;
        this.currentVisit = currentTime = String.valueOf(System.currentTimeMillis());
        this.firstVisit = this.preferences.get("first_visit", null);
        if (this.firstVisit == null) {
            this.firstVisit = currentTime;
            this.preferences.put("first_visit", this.firstVisit);
        }
        this.lastVisit = this.preferences.get("last_visit", currentTime);
        this.visitCount = this.preferences.getLong("visit_count", 1L);
    }

    protected IEclipseUserAgent createEclipseUserAgent() {
        return new EclipseUserAgent();
    }

    public String getBrowserLanguage() {
        return this.eclipseUserAgent.getBrowserLanguage();
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getScreenColorDepth() {
        return this.screenColorDepth;
    }

    protected Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public String getUserAgent() {
        return this.eclipseUserAgent.toString();
    }

    public String getUserId() {
        String userId = this.preferences.get("eclipse_instance_id", null);
        if (userId == null) {
            userId = this.createIdentifier();
            this.preferences.put("eclipse_instance_id", userId);
            UsageReportPreferencesUtils.checkedSavePreferences(this.preferences, (Plugin)SubclipseToolsUsageActivator.getDefault(), GoogleAnalyticsEclipseMessages.EclipseEnvironment_Error_SavePreferences);
        }
        return userId;
    }

    private String createIdentifier() {
        StringBuffer builder = new StringBuffer();
        builder.append(Math.abs(this.random.nextLong()));
        builder.append(System.currentTimeMillis());
        return builder.toString();
    }

    public abstract String getKeyword();

    public String getCurrentVisit() {
        return this.currentVisit;
    }

    public String getFirstVisit() {
        return this.firstVisit;
    }

    public String getLastVisit() {
        return this.lastVisit;
    }

    public long getVisitCount() {
        return this.visitCount;
    }

    public void visit() {
        this.lastVisit = this.currentVisit;
        this.preferences.put("last_visit", this.lastVisit);
        this.currentVisit = String.valueOf(System.currentTimeMillis());
        ++this.visitCount;
        this.preferences.putLong("visit_count", this.visitCount);
        UsageReportPreferencesUtils.checkedSavePreferences(this.preferences, (Plugin)SubclipseToolsUsageActivator.getDefault(), GoogleAnalyticsEclipseMessages.EclipseEnvironment_Error_SavePreferences);
    }

    public String getFlashVersion() {
        return this.getJavaVersion();
    }

    private String getJavaVersion() {
        return System.getProperty(SYSPROP_JAVA_VERSION);
    }

    public IEclipseUserAgent getEclipseUserAgent() {
        return this.eclipseUserAgent;
    }

    public String getUserDefined() {
        return this.getLinuxDistroNameAndVersion();
    }

    protected String getLinuxDistroNameAndVersion() {
        return LinuxSystem.INSTANCE.getDistroNameAndVersion();
    }
}

