/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardConfigureTagsPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class ConfigureTagsAction
extends WorkspaceAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources = this.getSelectedResources();
        ISVNLocalResource[] svnResources = new ISVNLocalResource[resources.length];
        ISVNProperty lastProperty = null;
        int i = 0;
        while (i < resources.length) {
            svnResources[i] = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
            try {
                ISVNProperty property = svnResources[i].getSvnProperty("subclipse:tags");
                if (i > 0 && !this.propertiesEqual(property, lastProperty)) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigureTagsAction_1, (String)Messages.ConfigureTagsAction_2);
                    return;
                }
                lastProperty = property;
            }
            catch (SVNException sVNException) {}
            ++i;
        }
        SvnWizardConfigureTagsPage configureTagsPage = new SvnWizardConfigureTagsPage(svnResources);
        SvnWizard wizard = new SvnWizard(configureTagsPage);
        SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
        wizard.setParentDialog((Dialog)dialog);
        dialog.open();
    }

    private boolean propertiesEqual(ISVNProperty property1, ISVNProperty property2) {
        String value1 = null;
        String value2 = null;
        if (property1 != null) {
            value1 = property1.getValue();
        }
        if (property2 != null) {
            value2 = property2.getValue();
        }
        if (value1 == null) {
            value1 = "";
        }
        if (value2 == null) {
            value2 = "";
        }
        return value1.equals(value2);
    }
}

