/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;

public class PasswordPromptDialog
extends TrayDialog {
    private String realm;
    private String username;
    private String password;
    private boolean save;
    private boolean maySave;
    private Text userText;
    private Text passwordText;
    private Button saveButton;
    private Button okButton;
    private static int WIDTH = 300;

    public PasswordPromptDialog(Shell parentShell, String realm, String username, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.username = username;
        this.maySave = maySave;
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("PasswordPromptDialog.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Label realmLabel = new Label(rtnGroup, 0);
        realmLabel.setText(Policy.bind("PasswordPromptDialog.repository"));
        Text realmText = new Text(rtnGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = WIDTH;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        Label userLabel = new Label(rtnGroup, 0);
        userLabel.setText(Policy.bind("PasswordPromptDialog.username"));
        this.userText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.userText.setLayoutData((Object)gd);
        this.userText.setText(this.username == null ? "" : this.username);
        Label pwdLabel = new Label(rtnGroup, 0);
        pwdLabel.setText(Policy.bind("PasswordPromptDialog.password"));
        this.passwordText = new Text(rtnGroup, 2048);
        gd = new GridData();
        gd.widthHint = WIDTH;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.setEchoChar('*');
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("PasswordPromptDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                PasswordPromptDialog.this.okButton.setEnabled(PasswordPromptDialog.this.userText.getText().trim().length() > 0 || PasswordPromptDialog.this.passwordText.getText().trim().length() > 0);
            }
        };
        this.userText.addModifyListener(modifyListener);
        this.passwordText.addModifyListener(modifyListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)rtnGroup, "org.tigris.subversion.subclipse.ui.password_prompt_dialog_context");
        if (this.username != null) {
            this.passwordText.setFocus();
        } else {
            this.userText.setFocus();
        }
        return rtnGroup;
    }

    public Button createButton(Composite parent, int id, String label, boolean isDefault) {
        Button button = super.createButton(parent, id, label, isDefault);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    protected void okPressed() {
        this.username = this.userText.getText().trim();
        this.password = this.passwordText.getText().trim();
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        super.okPressed();
    }

    public boolean isSave() {
        return this.save;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }
}

