/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.repo.SVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;

public class ConfigurationWizardAutoconnectPage
extends SVNWizardPage {
    private boolean validate = true;
    private LocalResourceStatus status;
    ISVNRepositoryLocation location;

    public ConfigurationWizardAutoconnectPage(String pageName, String title, ImageDescriptor titleImage, LocalResourceStatus status) {
        super(pageName, title, titleImage);
        this.status = status;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.sharing_autoconnect_page_context");
        Label description = this.createWrappingLabel(composite, Policy.bind("RepositorySelectionPage.description"), 0, 2);
        description.setText(Policy.bind("ConfigurationWizardAutoconnectPage.description"));
        if (this.location == null) {
            return;
        }
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.user"));
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getUsername());
        ConfigurationWizardAutoconnectPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.host"));
        ConfigurationWizardAutoconnectPage.createLabel(composite, this.location.getUrl().toString());
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        ConfigurationWizardAutoconnectPage.createLabel(composite, "");
        final Button check = new Button(composite, 32);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        check.setLayoutData((Object)data);
        check.setText(Policy.bind("ConfigurationWizardAutoconnectPage.validate"));
        check.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardAutoconnectPage.this.validate = check.getSelection();
            }
        });
        check.setSelection(true);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setProject(IProject project) {
        try {
            if (this.status == null) {
                SVNUIPlugin.openError(null, Policy.bind("ConfigurationWizardAutoconnectPage.noSyncInfo"), Policy.bind("ConfigurationWizardAutoconnectPage.noSVNDirectory"), null);
                return;
            }
            this.location = SVNRepositoryLocation.fromString((String)this.status.getUrlString());
        }
        catch (TeamException e) {
            SVNUIPlugin.openError(null, null, null, e);
        }
    }

    public LocalResourceStatus getSharingStatus() {
        return this.status;
    }

    public ISVNRepositoryLocation getLocation() {
        return this.location;
    }
}

