/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.resources.LocalFile;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNMoveDeleteHook
implements IMoveDeleteHook {
    private static Set deletedFiles = new HashSet();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (SVNWorkspaceRoot.isLinkedResource((IResource)file)) {
            return false;
        }
        LocalFile resource = new LocalFile(file);
        try {
            try {
                block12: {
                    block11: {
                        block10: {
                            if (resource.isManaged()) break block10;
                            break block11;
                        }
                        if (!this.getDeferFileDelete((IResource)file)) break block12;
                    }
                    Object var7_6 = null;
                    monitor.done();
                    return false;
                }
                monitor.beginTask(null, 1000);
                deletedFiles.add(file);
                resource.delete();
                tree.deletedFile(file);
            }
            catch (SVNException e) {
                tree.failed(e.getStatus());
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return true;
    }

    public static boolean isDeleted(IFile file) {
        return deletedFiles.contains(file);
    }

    public static void removeFromDeletedFileList(IFile file) {
        deletedFiles.remove(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        block8: {
            block7: {
                if (SVNWorkspaceRoot.isLinkedResource((IResource)folder)) {
                    return false;
                }
                LocalFolder resource = new LocalFolder((IContainer)folder);
                try {
                    try {
                        if (!resource.isManaged()) {
                            Object var7_6 = null;
                            break block7;
                        }
                        monitor.beginTask(null, 1000);
                        resource.delete();
                    }
                    catch (SVNException e) {
                        tree.failed(e.getStatus());
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var7_8 = null;
        monitor.done();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        block18: {
            block17: {
                if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
                    return false;
                }
                try {
                    try {
                        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
                        if (repositoryProvider == null) throw new SVNException(Policy.bind("SVNMoveHook.moveFileException"));
                        if (!(repositoryProvider instanceof SVNTeamProvider)) {
                            throw new SVNException(Policy.bind("SVNMoveHook.moveFileException"));
                        }
                        LocalFile resource = new LocalFile(source);
                        if (!resource.isManaged()) {
                            Object var13_9 = null;
                            break block17;
                        }
                        ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                        monitor.beginTask(null, 1000);
                        try {
                            try {
                                OperationManager.getInstance().beginOperation(svnClient);
                                if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                                    SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                                    provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                                    ISVNLocalResource parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent());
                                    if (parent != null) {
                                        parent.refreshStatus();
                                    }
                                }
                                svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                                tree.movedFile(source, destination);
                                destination.refreshLocal(0, monitor);
                            }
                            catch (SVNClientException e) {
                                throw SVNException.wrapException((Exception)((Object)e));
                            }
                            catch (TeamException e) {
                                throw SVNException.wrapException(e);
                            }
                            catch (CoreException e) {
                                throw SVNException.wrapException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_19 = null;
                            OperationManager.getInstance().endOperation(false);
                            throw throwable;
                        }
                        {
                            Object var11_20 = null;
                            OperationManager.getInstance().endOperation(false);
                        }
                    }
                    catch (SVNException e) {
                        tree.failed(e.getStatus());
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var13_11 = null;
        monitor.done();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        block17: {
            block16: {
                if (SVNWorkspaceRoot.isLinkedResource((IResource)source)) {
                    return false;
                }
                try {
                    try {
                        LocalFolder resource = new LocalFolder((IContainer)source);
                        if (!resource.isManaged()) {
                            Object var13_8 = null;
                            break block16;
                        }
                        RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)destination.getProject());
                        if (repositoryProvider == null) throw new SVNException(Policy.bind("SVNMoveHook.moveFolderException"));
                        if (!(repositoryProvider instanceof SVNTeamProvider)) {
                            throw new SVNException(Policy.bind("SVNMoveHook.moveFolderException"));
                        }
                        monitor.beginTask(null, 1000);
                        ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                        try {
                            try {
                                OperationManager.getInstance().beginOperation(svnClient);
                                if (!SVNWorkspaceRoot.getSVNFolderFor(destination.getParent()).isManaged()) {
                                    SVNTeamProvider provider = (SVNTeamProvider)repositoryProvider;
                                    provider.add(new IResource[]{destination.getParent()}, 0, (IProgressMonitor)new NullProgressMonitor());
                                    ISVNLocalResource parent = SVNWorkspaceRoot.getSVNResourceFor((IResource)destination.getParent());
                                    if (parent != null) {
                                        parent.refreshStatus();
                                    }
                                }
                                svnClient.move(source.getLocation().toFile(), destination.getLocation().toFile(), true);
                                tree.movedFolderSubtree(source, destination);
                                destination.refreshLocal(2, monitor);
                            }
                            catch (SVNClientException e) {
                                throw SVNException.wrapException((Exception)((Object)e));
                            }
                            catch (CoreException e) {
                                throw SVNException.wrapException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_18 = null;
                            OperationManager.getInstance().endOperation(false);
                            throw throwable;
                        }
                        {
                            Object var11_19 = null;
                            OperationManager.getInstance().endOperation(false);
                        }
                    }
                    catch (SVNException e) {
                        tree.failed(e.getStatus());
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return false;
        }
        Object var13_10 = null;
        monitor.done();
        return true;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    private boolean getDeferFileDelete(IResource resource) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
        ISVNProperty property = null;
        try {
            if (svnResource.isManaged()) {
                property = svnResource.getSvnProperty("DeferFileDelete");
            }
        }
        catch (SVNException sVNException) {}
        if (property != null && property.getValue() != null && property.getValue().trim().length() > 0) {
            return property.getValue().equalsIgnoreCase("true");
        }
        IResource checkResource = resource;
        while (checkResource.getParent() != null) {
            if ((checkResource = checkResource.getParent()).getParent() == null) {
                return false;
            }
            svnResource = SVNWorkspaceRoot.getSVNResourceFor(checkResource);
            try {
                if (svnResource.isManaged()) {
                    property = svnResource.getSvnProperty("DeferFileDelete");
                }
            }
            catch (SVNException sVNException) {}
            if (property == null || property.getValue() == null || property.getValue().trim().length() <= 0) continue;
            return property.getValue().equalsIgnoreCase("true");
        }
        return false;
    }
}

