/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.svnkit;

import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitPromptUserPassword;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnectorFactory;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class SvnKitClientAdapter
extends AbstractJhlClientAdapter {
    public SvnKitClientAdapter() {
        this(null, null, null);
    }

    public SvnKitClientAdapter(SVNClient owner, IHTTPConnectionFactory httpConnectionFactory, ISVNConnectorFactory svnConnectorFactory) {
        this.svnClient = SVNClientImpl.newInstance((SVNClient)owner, (IHTTPConnectionFactory)httpConnectionFactory, (ISVNConnectorFactory)svnConnectorFactory);
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressListener((ProgressListener)this.progressListener);
    }

    public boolean isThreadsafe() {
        return false;
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        if ("bdb".equalsIgnoreCase(repositoryType)) {
            throw new SVNClientException("SVNKit only supports fsfs repository type.");
        }
        try {
            boolean force = false;
            boolean enableRevisionProperties = false;
            SVNRepositoryFactory.createLocalRepository((File)path, (boolean)enableRevisionProperties, (boolean)force);
        }
        catch (SVNException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            SvnKitPromptUserPassword prompt = new SvnKitPromptUserPassword(callback);
            this.setPromptUserPassword((PromptUserPassword)prompt);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean atomic) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(3);
            String[] files = new String[paths.length];
            String commandLine = "commit -m \"" + fixedMessage + "\"";
            if (!recurse) {
                commandLine = String.valueOf(commandLine) + " -N";
            }
            if (keepLocks) {
                commandLine = String.valueOf(commandLine) + " --no-unlock";
            }
            int i = 0;
            while (i < paths.length) {
                files[i] = SvnKitClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = String.valueOf(commandLine) + " " + files[i];
                ++i;
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            long[] newRev = ((SVNClientImpl)this.svnClient).commit(files, fixedMessage, recurse, keepLocks, atomic);
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public boolean canCommitAcrossWC() {
        return true;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        ISVNStatus[] statuses = super.getStatus(path, descend, getAll, contactServer, ignoreExternals);
        if (statuses.length == 0) {
            if (getAll) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            ISVNStatus[] reCheckStatuses = super.getStatus(path, false, true, false, true);
            if (reCheckStatuses.length == 0) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            return new ISVNStatus[0];
        }
        return statuses;
    }
}

