/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.stringgroup.BlancoDbLoggingModeStringGroup;
import blanco.db.common.stringgroup.BlancoDbSqlInfoScrollStringGroup;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author tosiki iga
 */
public class PrepareStatementMethod2 extends BlancoDbAbstractMethod {
    public PrepareStatementMethod2(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "prepareStatement", "^ꂽSQLăvRpC{(ISQL)܂B");
        fCgClass.getMethodList().add(cgMethod);

        if (fSqlInfo.getDynamicSql() == false) {
            // I SQL ptO OFF ̏ꍇAI SQL ̂߂̂̃\bh protected ܂B
            cgMethod.setAccess("protected");
        }

        cgMethod.getParameterList()
                .add(fCgFactory
                        .createParameter("query", "java.lang.String",
                                "vRpC{SQLBISQL̏ꍇɂ́Äɂ͉Hꂽ̎s\SQL^܂B"));

        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List<String> listDesc = cgMethod.getLangDoc()
                .getDescriptionList();

        listDesc.add("̃\bh́AIɓeω悤 SQL sKvꍇɂ̂ݗp܂B<br>");
        if (fSqlInfo.getDynamicSql() == false) {
            listDesc.add("I SQL 𗘗pKvꍇɂ́ASQL `ŁuISQLvugpvɕύXĂBύX͊O痘p\ɂȂ܂B<br>");
        } else {
            listDesc.add("SQL `ŁuISQLvugpvɐݒ肳Ă܂B<br>");
        }
        listDesc.add("I JDBC hCo Connection.prepareStatement Ăяo܂B<br>");

        if (fSqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.ITERATOR) {
            // ^̏ꍇɂ̂ݏo͂܂B

            // TODO
            // BlancoDbSqlInfoScrollStringGroup.NOT_DEFINED̏ꍇɂ͉oׂ͂ł͂Ȃ̂A1.6.4Ƃ̌݊mۂ̂
            // XN[LangDocɏo͂Ă܂B

            if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_FORWARD_ONLY
                    && fSqlInfo.getUpdatable() == false) {
                // J[\ŊXV\OFF̏ꍇɂ́ALangDocɏo͂܂B
            } else {
                listDesc.add("XN[: "
                        + new BlancoDbSqlInfoScrollStringGroup()
                                .convertToString(fSqlInfo.getScroll()));
                if (fSqlInfo.getUpdatable()) {
                    listDesc.add("XV\: L");
                }
            }
        }

        final List<String> listLine = cgMethod.getLineList();

        if(fDbSetting.getLoggingsql()) {
        	// TODO b: Wo͂ɏóB 
			listLine.add("fLogSqlInParam = \"\";");
		}

        
        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.DEBUG:
                listLine.add("if (fLog.isDebugEnabled()) {");
                listLine.add("fLog.debug(\"" + cgMethod.getName()
                        + ": query = \" + query);");
                listLine.add("}");
                break;
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
                listLine.add("fLog.info(\"" + fSqlInfo.getName()
                        + "sSQL\\n\" + query);");
                break;
            }
            listLine.add("");
        }

        listLine.add("close();");

        // TODO XN[w̏ꍇ JDBC APIXN[Ŏw肵悤ƂA̎dl
        // 1.6.4Ɠ삪قȂĂ܂܂B
        // TODO 1.6.4Ƃ̌݊D悵AXN[w薳̏ꍇ̏܂B

        if (fSqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.INVOKER
                || fSqlInfo.getType() == BlancoDbSqlInfoTypeStringGroup.CALLER) {
            // s^Eďo^̏ꍇɂ́APprepareStatementĂяo܂B
            listLine.add("fStatement = fConnection.prepareStatement(query);");
        } else if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_FORWARD_ONLY
                && fSqlInfo.getUpdatable() == false) {
            // ^̂Ap[^̃oG[VPȏꍇɂ́APprepareStatementĂяo܂B
            listLine.add("fStatement = fConnection.prepareStatement(query);");
        } else {
            // oG[V̓eɍ킹Ĉ𐶐܂B
            // ^ BlancoDbSqlInfoScrollStringGroup.NOT_DEFINED ɂĂ
            // ʉ߂_ɒӂĂB 1.6.4Ƃ̌݊̂߂ɕKvłB

            String resultSetType = "ResultSet.TYPE_FORWARD_ONLY";
            String resultSetConcurrency = "ResultSet.CONCUR_READ_ONLY";
            if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_SCROLL_INSENSITIVE) {
                resultSetType = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_SCROLL_SENSITIVE) {
                resultSetType = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            if (fSqlInfo.getUpdatable()) {
                resultSetConcurrency = "ResultSet.CONCUR_UPDATABLE";
            }
            listLine.add("fStatement = fConnection.prepareStatement(query, "
                    + resultSetType + ", " + resultSetConcurrency + ");");
        }

        if (fDbSetting.getStatementTimeout() >= 0) {
            listLine.add("// Xe[gg^CAEglɂăftHglZbg܂B");
            listLine.add("fStatement.setQueryTimeout("
                    + fDbSetting.getStatementTimeout() + ");");
        }
    }
}