/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.operation.OpenRemoteFileOperation;

public class OpenFileWithExternalAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        this.runScheduled((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)resources[0]}, 1));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isEnabled()) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            action.setImageDescriptor(SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getSystemExternalEditorImageDescriptor(resources[0].getName()));
        } else {
            action.setImageDescriptor(null);
        }
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length != 1 || !(resources[0] instanceof IRepositoryFile)) {
            return false;
        }
        return SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().isSystemExternalEditorAvailable(resources[0].getName());
    }
}

