/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.discovery;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.discovery.model.ConnectorDescriptor;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.discovery.IConnectorsInstallJob;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareInstallProfileJob_3_6
implements IConnectorsInstallJob {
    private static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    private List<ConnectorDescriptor> installableConnectors;
    private final ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
    private Set<URI> repositoryLocations;

    @Override
    public void setInstallableConnectors(List<ConnectorDescriptor> installableConnectors) {
        if (installableConnectors == null || installableConnectors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.installableConnectors = new ArrayList<ConnectorDescriptor>(installableConnectors);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)SVNUIMessages.InstallConnectorsJob_task_configuring, (int)100);
            try {
                final IInstallableUnit[] ius = this.computeInstallableUnits(monitor.newChild(50));
                this.checkCancelled((IProgressMonitor)monitor);
                final InstallOperation installOperation = this.resolve((IProgressMonitor)monitor.newChild(50), ius, this.repositoryLocations.toArray(new URI[0]));
                this.checkCancelled((IProgressMonitor)monitor);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        PrepareInstallProfileJob_3_6.this.provisioningUI.openInstallWizard(Arrays.asList(ius), installOperation, null);
                    }
                });
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private InstallOperation resolve(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        InstallOperation installOperation = this.provisioningUI.getInstallOperation(Arrays.asList(ius), repositories);
        IStatus operationStatus = installOperation.resolveModal((IProgressMonitor)new SubProgressMonitor(monitor, this.installableConnectors.size()));
        if (operationStatus.getSeverity() > 2) {
            throw new CoreException(operationStatus);
        }
        return installOperation;
    }

    public IInstallableUnit[] computeInstallableUnits(SubMonitor monitor) throws CoreException {
        try {
            monitor.setWorkRemaining(100);
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            List<IInstallableUnit> installableUnits = this.queryInstallableUnits(monitor.newChild(50), repositories);
            this.removeOldVersions(installableUnits);
            this.checkForUnavailable(installableUnits);
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.svn.core.svnnature", SVNUIMessages.InstallConnectorsJob_unexpectedError_url, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void checkForUnavailable(List<IInstallableUnit> installableUnits) throws CoreException {
        HashSet<String> foundIds = new HashSet<String>();
        for (IInstallableUnit unit : installableUnits) {
            foundIds.add(unit.getId());
        }
        String message = "";
        String detailedMessage = "";
        for (ConnectorDescriptor descriptor : this.installableConnectors) {
            StringBuilder unavailableIds = null;
            for (String id : this.getFeatureIds(descriptor)) {
                if (foundIds.contains(id)) continue;
                if (unavailableIds == null) {
                    unavailableIds = new StringBuilder();
                } else {
                    unavailableIds.append(SVNUIMessages.InstallConnectorsJob_commaSeparator);
                }
                unavailableIds.append(id);
            }
            if (unavailableIds == null) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + SVNUIMessages.InstallConnectorsJob_commaSeparator;
            }
            message = String.valueOf(message) + descriptor.getName();
            if (detailedMessage.length() > 0) {
                detailedMessage = String.valueOf(detailedMessage) + SVNUIMessages.InstallConnectorsJob_commaSeparator;
            }
            detailedMessage = String.valueOf(detailedMessage) + NLS.bind((String)SVNUIMessages.PrepareInstallProfileJob_notFoundDescriptorDetail, (Object[])new Object[]{descriptor.getName(), unavailableIds.toString(), descriptor.getSiteUrl()});
        }
        if (message.length() > 0) {
            final boolean[] okayToProceed = new boolean[1];
            final String finalMessage = message;
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    okayToProceed[0] = MessageDialog.openQuestion((Shell)UIMonitorUtility.getShell(), (String)SVNUIMessages.InstallConnectorsJob_questionProceed, (String)NLS.bind((String)SVNUIMessages.InstallConnectorsJob_questionProceed_long, (Object[])new Object[]{finalMessage}));
                }
            });
            if (!okayToProceed[0]) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.svn.core.svnnature", NLS.bind((String)SVNUIMessages.InstallConnectorsJob_connectorsNotAvailable, (Object)detailedMessage), null));
            }
        }
    }

    private void removeOldVersions(List<IInstallableUnit> installableUnits) {
        Version version;
        HashMap<String, Version> symbolicNameToVersion = new HashMap<String, Version>();
        for (IInstallableUnit unit : installableUnits) {
            version = (Version)symbolicNameToVersion.get(unit.getId());
            if (version != null && version.compareTo((Object)unit.getVersion()) != -1) continue;
            symbolicNameToVersion.put(unit.getId(), unit.getVersion());
        }
        if (symbolicNameToVersion.size() != installableUnits.size()) {
            for (IInstallableUnit unit : new ArrayList<IInstallableUnit>(installableUnits)) {
                version = (Version)symbolicNameToVersion.get(unit.getId());
                if (version.equals(unit.getVersion())) continue;
                installableUnits.remove(unit);
            }
        }
    }

    private List<IInstallableUnit> queryInstallableUnits(SubMonitor monitor, List<IMetadataRepository> repositories) throws URISyntaxException {
        ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
        monitor.setWorkRemaining(repositories.size());
        for (IMetadataRepository repository : repositories) {
            this.checkCancelled((IProgressMonitor)monitor);
            Set<String> installableUnitIdsThisRepository = this.getDescriptorIds(repository);
            IQuery query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ && properties['org.eclipse.equinox.p2.type.group'] == true ", (Object[])new Object[0]);
            IQueryResult result = repository.query(query, (IProgressMonitor)monitor.newChild(1));
            for (IInstallableUnit iu : result) {
                String id = iu.getId();
                if (!installableUnitIdsThisRepository.contains(id)) continue;
                installableUnits.add(iu);
            }
        }
        return installableUnits;
    }

    private List<IMetadataRepository> addRepositories(SubMonitor monitor) throws MalformedURLException, URISyntaxException, ProvisionException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        this.repositoryLocations = new HashSet<URI>();
        monitor.setWorkRemaining(this.installableConnectors.size() * 5);
        for (ConnectorDescriptor descriptor : this.installableConnectors) {
            URI uri = new URL(descriptor.getSiteUrl()).toURI();
            if (this.repositoryLocations.add(uri)) {
                this.checkCancelled((IProgressMonitor)monitor);
                repositoryTracker.addRepository(uri, null, session);
            }
            monitor.worked(1);
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        monitor.setWorkRemaining(repositories.size());
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        for (URI uri : this.repositoryLocations) {
            this.checkCancelled((IProgressMonitor)monitor);
            IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
            repositories.add(repository);
        }
        return repositories;
    }

    private Set<String> getDescriptorIds(IMetadataRepository repository) throws URISyntaxException {
        HashSet<String> installableUnitIdsThisRepository = new HashSet<String>();
        for (ConnectorDescriptor descriptor : this.installableConnectors) {
            try {
                if (!repository.getLocation().equals(new URL(descriptor.getSiteUrl()).toURI())) continue;
                installableUnitIdsThisRepository.addAll(this.getFeatureIds(descriptor));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return installableUnitIdsThisRepository;
    }

    private Set<String> getFeatureIds(ConnectorDescriptor descriptor) {
        HashSet<String> featureIds = new HashSet<String>();
        for (String id : descriptor.getInstallableUnits()) {
            if (!id.endsWith(P2_FEATURE_GROUP_SUFFIX)) {
                id = String.valueOf(id) + P2_FEATURE_GROUP_SUFFIX;
            }
            featureIds.add(id);
        }
        return featureIds;
    }
}

