/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.CommitSetPanel;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class SVNChangeSetCapability
extends ChangeSetCapability {
    public static boolean isEnabled = false;

    public static String getProposedComment(IResource[] resourcesToCommit) {
        String retVal = null;
        ChangeSet[] sets = SVNTeamUIPlugin.instance().getModelCangeSetManager().getSets();
        int i = 0;
        while (i < sets.length) {
            if (SVNChangeSetCapability.containsOneOf(sets[i], resourcesToCommit)) {
                String comment = sets[i].getComment();
                retVal = retVal == null ? comment : String.valueOf(retVal) + "\n" + comment;
            }
            ++i;
        }
        return retVal;
    }

    public static boolean containsOneOf(ChangeSet set, IResource[] resourcesToCommit) {
        int i = 0;
        while (i < resourcesToCommit.length) {
            if (set.contains(resourcesToCommit[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean supportsCheckedInChangeSets() {
        return true;
    }

    public SyncInfoSetChangeSetCollector createSyncInfoSetChangeSetCollector(ISynchronizePageConfiguration configuration) {
        isEnabled = true;
        return new SVNChangeSetCollector(configuration);
    }

    public boolean supportsActiveChangeSets() {
        return true;
    }

    public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, IDiff[] diffs) {
        ActiveChangeSet set = this.getActiveChangeSetManager().createSet(SVNUIMessages.ChangeSet_NewSet, new IDiff[0]);
        CommitSetPanel panel = new CommitSetPanel(set, this.getResources(diffs), 0);
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        set.add(diffs);
        return set;
    }

    private IResource[] getResources(IDiff[] diffs) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
        CommitSetPanel panel = new CommitSetPanel(set, set.getResources(), 1);
        DefaultDialog dialog = new DefaultDialog(configuration.getSite().getShell(), panel);
        dialog.open();
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return SVNTeamUIPlugin.instance().getModelCangeSetManager();
    }

    public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsActiveChangeSets() && configuration.getMode() != 1;
    }

    public boolean enableCheckedInChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsCheckedInChangeSets() && configuration.getMode() != 2;
    }
}

