/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.local.management.FindRelatedProjectsOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.ProjectListComposite;
import org.eclipse.team.svn.ui.composite.RepositoryPropertiesTabFolder;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.NonValidLocationErrorDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class AddRepositoryLocationPage
extends AbstractVerifiedWizardPage {
    protected RepositoryPropertiesTabFolder propertiesTabFolder;
    protected IActionOperation operationToPerform;
    protected IRepositoryLocation editable;
    protected boolean alreadyConnected;
    protected boolean createNew;
    protected String initialUrl;
    protected String oldUrl;
    protected String oldLabel;

    public AddRepositoryLocationPage() {
        this((IRepositoryLocation)null);
    }

    public AddRepositoryLocationPage(IRepositoryLocation editable) {
        super(AddRepositoryLocationPage.class.getName(), SVNUIMessages.AddRepositoryLocationPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.AddRepositoryLocationPage_Description);
        this.editable = editable;
        if (editable != null) {
            this.oldUrl = editable.getUrl();
            this.oldLabel = editable.getLabel();
        }
        this.alreadyConnected = false;
        this.createNew = true;
    }

    protected Composite createControlImpl(Composite parent) {
        this.propertiesTabFolder = new RepositoryPropertiesTabFolder(parent, 0, this, this.editable);
        this.propertiesTabFolder.initialize();
        this.propertiesTabFolder.setLayoutData(new GridData(768));
        this.propertiesTabFolder.resetChanges();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.newReposWizContext");
        return this.propertiesTabFolder;
    }

    public void setInitialUrl(String initialUrl) {
        this.initialUrl = initialUrl;
        this.alreadyConnected = initialUrl != null;
        if (this.alreadyConnected) {
            this.createNew = initialUrl.trim().length() == 0;
            this.getRepositoryLocation().setUrl(initialUrl);
            this.propertiesTabFolder.resetChanges();
        }
    }

    public void setForceDisableRoots(boolean force) {
        this.propertiesTabFolder.setForceDisableRoots(force, this.initialUrl == null || this.initialUrl.length() == 0 ? null : new AbstractFormattedVerifier(SVNUIMessages.AddRepositoryLocationPage_RootURL){

            protected String getErrorMessageImpl(Control input) {
                String url = this.getText(input);
                if (!SVNUtility.createPathForSVNUrl((String)url).isPrefixOf(SVNUtility.createPathForSVNUrl((String)SVNUtility.decodeURL((String)AddRepositoryLocationPage.this.initialUrl)))) {
                    return SVNUIMessages.format((String)SVNUIMessages.AddRepositoryLocationPage_FixedURL_Verifier_Error, (Object[])new String[]{"$FIELD_NAME$", AddRepositoryLocationPage.this.initialUrl});
                }
                return null;
            }

            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        });
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.propertiesTabFolder.getRepositoryLocation();
    }

    public boolean canFlipToNextPage() {
        return (!this.alreadyConnected || this.createNew) && this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        return this.performFinish() ? super.getNextPage() : this;
    }

    public IWizardPage getPreviousPage() {
        this.performCancel();
        return super.getPreviousPage();
    }

    public void performCancel() {
        this.operationToPerform = null;
    }

    public boolean performFinish() {
        MessageDialog dialog;
        String endsPart;
        String newUrl = this.propertiesTabFolder.getLocationUrl();
        String oldUuid = null;
        IProject[] projectsArray = new IProject[]{};
        if (this.editable != null && SVNRemoteStorage.instance().getRepositoryLocation(this.editable.getId()) != null && !newUrl.equals(this.oldUrl)) {
            FindRelatedProjectsOperation op = new FindRelatedProjectsOperation(this.editable);
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
            projectsArray = (IProject[])op.getResources();
            if (projectsArray.length > 0) {
                SVNEntryInfo info = this.getLocationInfo(this.editable);
                oldUuid = info == null ? null : info.reposUUID;
            }
        }
        this.propertiesTabFolder.saveChanges();
        if (this.propertiesTabFolder.isStructureEnabled() && ((endsPart = SVNUtility.createPathForSVNUrl((String)newUrl).lastSegment()).equals(this.propertiesTabFolder.getRepositoryLocation().getTrunkLocation()) || endsPart.equals(this.propertiesTabFolder.getRepositoryLocation().getBranchesLocation()) || endsPart.equals(this.propertiesTabFolder.getRepositoryLocation().getTagsLocation()))) {
            final int[] result = new int[1];
            dialog = new MessageDialog(this.getShell(), SVNUIMessages.AddRepositoryLocationPage_Normalize_Title, null, SVNUIMessages.AddRepositoryLocationPage_Normalize_Message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 0) {
                IRepositoryLocation location = this.editable == null ? this.getRepositoryLocation() : this.editable;
                boolean useCustomLabel = false;
                useCustomLabel = !location.getUrl().equals(location.getLabel());
                newUrl = SVNUtility.createPathForSVNUrl((String)newUrl).removeLastSegments(1).toString();
                location.setUrl(newUrl);
                if (!useCustomLabel) {
                    location.setLabel(newUrl);
                }
                location.reconfigure();
            }
        }
        ProjectListPanel panel = null;
        if (projectsArray.length > 0) {
            this.editable.reconfigure();
            SVNEntryInfo newInfo = this.getLocationInfo(this.editable);
            if (newInfo == null) {
                panel = new ProjectListPanel(projectsArray, false);
            } else if (oldUuid != null && !oldUuid.equals(newInfo.reposUUID)) {
                panel = new ProjectListPanel(projectsArray, true);
            }
            if (panel != null) {
                this.editable.setUrl(this.oldUrl);
                this.editable.setLabel(this.oldLabel);
                this.editable.reconfigure();
                new DefaultDialog(this.getShell(), panel).open();
            }
        }
        if (this.propertiesTabFolder.isValidateOnFinishRequested() && panel == null) {
            final Exception[] problem = new Exception[1];
            UIMonitorUtility.doTaskNowDefault(this.getShell(), (IActionOperation)new AbstractActionOperation("Operation_ValidateLocation", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    problem[0] = SVNUtility.validateRepositoryLocation((IRepositoryLocation)AddRepositoryLocationPage.this.propertiesTabFolder.getRepositoryLocation());
                }
            }, false);
            if (problem[0] != null && (dialog = new NonValidLocationErrorDialog(this.getShell(), problem[0].getMessage())).open() != 0) {
                return false;
            }
        }
        boolean shouldntBeAdded = this.editable == null ? false : SVNRemoteStorage.instance().getRepositoryLocation(this.editable.getId()) != null;
        AbstractActionOperation mainOp = shouldntBeAdded ? new AbstractActionOperation("Operation_CommitLocationChanges", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                AddRepositoryLocationPage.this.editable.reconfigure();
            }
        } : new AddRepositoryLocationOperation(this.getRepositoryLocation());
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        op.add((IActionOperation)(shouldntBeAdded ? new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{this.editable}, true) : new RefreshRepositoryLocationsOperation(false)));
        this.operationToPerform = op;
        return true;
    }

    public IActionOperation getOperationToPeform() {
        return this.operationToPerform;
    }

    protected SVNEntryInfo getLocationInfo(IRepositoryLocation location) {
        ISVNConnector proxy = location.acquireSVNProxy();
        SVNEntryInfo[] infos = null;
        try {
            try {
                infos = SVNUtility.info((ISVNConnector)proxy, (SVNEntryRevisionReference)SVNUtility.getEntryRevisionReference((IRepositoryResource)location.getRoot()), (int)0, (ISVNProgressMonitor)new SVNNullProgressMonitor());
            }
            catch (Exception exception) {
                location.releaseSVNProxy(proxy);
                return null;
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        return infos != null && infos.length > 0 ? infos[0] : null;
    }

    protected static class ProjectListPanel
    extends AbstractDialogPanel {
        protected IProject[] resources;
        protected TableViewer tableViewer;

        public ProjectListPanel(IProject[] input, boolean differentUuid) {
            super(new String[]{IDialogConstants.OK_LABEL});
            this.dialogTitle = SVNUIMessages.AddRepositoryLocationPage_ProjectList_Title;
            this.dialogDescription = SVNUIMessages.AddRepositoryLocationPage_ProjectList_Description;
            this.defaultMessage = differentUuid ? SVNUIMessages.AddRepositoryLocationPage_ProjectList_Message1 : SVNUIMessages.AddRepositoryLocationPage_ProjectList_Message2;
            this.resources = input;
        }

        public void createControlsImpl(Composite parent) {
            ProjectListComposite composite = new ProjectListComposite(parent, 4, this.resources, false);
            composite.initialize();
        }

        protected void saveChangesImpl() {
        }

        protected void cancelChangesImpl() {
        }
    }
}

