/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.discovery.model.ConnectorDescriptorKind;
import org.eclipse.team.svn.core.discovery.model.FeatureFilter;
import org.eclipse.team.svn.core.discovery.model.Icon;
import org.eclipse.team.svn.core.discovery.model.Overview;
import org.eclipse.team.svn.core.discovery.model.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorDescriptor {
    protected List<ConnectorDescriptorKind> kind = new ArrayList<ConnectorDescriptorKind>();
    protected String name;
    protected String provider;
    protected String license;
    protected String description;
    protected String siteUrl;
    protected List<String> installableUnits = new ArrayList<String>();
    protected String categoryId;
    protected String platformFilter;
    protected String groupId;
    protected List<FeatureFilter> featureFilter = new ArrayList<FeatureFilter>();
    protected Icon icon;
    protected Overview overview;

    public List<ConnectorDescriptorKind> getKind() {
        return this.kind;
    }

    public void setKind(List<ConnectorDescriptorKind> kind) {
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public List<String> getInstallableUnits() {
        return this.installableUnits;
    }

    public void setInstallableUnits(List<String> id) {
        this.installableUnits = id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getPlatformFilter() {
        return this.platformFilter;
    }

    public void setPlatformFilter(String platformFilter) {
        this.platformFilter = platformFilter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public List<FeatureFilter> getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(List<FeatureFilter> featureFilter) {
        this.featureFilter = featureFilter;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public void setOverview(Overview overview) {
        this.overview = overview;
    }

    public void validate() throws ValidationException {
        if (this.kind == null || this.kind.isEmpty()) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_kind);
        }
        if (this.name == null || this.name.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_name);
        }
        if (this.provider == null || this.provider.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_provider);
        }
        if (this.license == null || this.license.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_license);
        }
        if (this.siteUrl == null || this.siteUrl.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_siteUrl);
        }
        try {
            new URL(this.siteUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_invalid_connectorDescriptor_siteUrl);
        }
        if (this.installableUnits == null || this.installableUnits.isEmpty()) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_id);
        }
        if (this.categoryId == null || this.categoryId.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorDescriptor_must_specify_connectorDescriptor_categoryId);
        }
        for (FeatureFilter featureFilterItem : this.featureFilter) {
            featureFilterItem.validate();
        }
        if (this.icon != null) {
            this.icon.validate();
        }
        if (this.overview != null) {
            this.overview.validate();
        }
    }
}

