/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.resource.ignore.rules.jdt;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.team.svn.core.extension.options.IIgnoreRecommendations;
import org.eclipse.team.svn.core.utility.FileUtility;

public class JDTIgnoreRecommendations
implements IIgnoreRecommendations {
    public boolean isAcceptableNature(IResource resource) throws CoreException {
        return FileUtility.hasNature((IResource)resource, (String)"org.eclipse.jdt.core.javanature");
    }

    public boolean isIgnoreRecommended(IResource resource) throws CoreException {
        return this.isOutput(resource);
    }

    public boolean isOutput(IResource resource) throws CoreException {
        IOpenable openable;
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath output = javaProject.getOutputLocation();
        if (!output.isPrefixOf(resource.getFullPath()) || output.equals((Object)project.getFullPath())) {
            return false;
        }
        if (!"bin".equals(output.lastSegment()) && (openable = javaProject.getOpenable()).isOpen()) {
            IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (output.isPrefixOf(roots[i].getPath())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

