/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.amateras.stepcounter.AreaComment;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.StepCounter;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.diffcount.Cutter;
import jp.sf.amateras.stepcounter.diffcount.DiffCounterUtil;
import jp.sf.amateras.stepcounter.diffcount.DiffSource;

public class DefaultStepCounter
implements StepCounter,
Cutter {
    private static Pattern CATEGORY_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]");
    private static Pattern IGNORE_PATTERN = Pattern.compile("\\[\\[IGNORE\\]\\]");
    private List<String> lineComments = new ArrayList<String>();
    private List<AreaComment> areaComments = new ArrayList<AreaComment>();
    private List<String> skipPatterns = new ArrayList<String>();
    private String fileType = "UNDEF";

    public void addSkipPattern(String pattern) {
        this.skipPatterns.add(pattern);
    }

    public String[] getSkipPatterns() {
        return this.skipPatterns.toArray(new String[this.skipPatterns.size()]);
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void addLineComment(String str) {
        this.lineComments.add(str);
    }

    public void addAreaComment(AreaComment area) {
        this.areaComments.add(area);
    }

    public CountResult count(File file, String charset) throws IOException {
        String charSetName = charset;
        if (charSetName == null) {
            charSetName = Charset.defaultCharset().name();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charSetName));
        String category = "";
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        try {
            String line = null;
            boolean areaFlag = false;
            AreaComment lastAreaComment = new AreaComment();
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (category.length() == 0 && (matcher = CATEGORY_PATTERN.matcher(line)).find()) {
                    category = matcher.group(1);
                }
                if (IGNORE_PATTERN.matcher(line).find()) {
                    return null;
                }
                String trimedLine = line.trim();
                if (!areaFlag) {
                    if (this.nonCheck(trimedLine)) {
                        ++non;
                        continue;
                    }
                    if (this.lineCommentCheck(trimedLine)) {
                        ++comment;
                        continue;
                    }
                    if (this.skipPatternCheck(trimedLine)) {
                        ++non;
                        continue;
                    }
                    lastAreaComment = this.areaCommentStartCheck(line);
                    if (lastAreaComment != null) {
                        ++comment;
                        areaFlag = true;
                        continue;
                    }
                    ++step;
                    continue;
                }
                ++comment;
                if (!this.areaCommentEndCheck(line, lastAreaComment)) continue;
                areaFlag = false;
            }
        }
        finally {
            reader.close();
        }
        return new CountResult(file, file.getName(), this.getFileType(), category, step, non, comment);
    }

    private boolean skipPatternCheck(String line) {
        int i = 0;
        while (i < this.skipPatterns.size()) {
            if (Pattern.matches(this.skipPatterns.get(i), line)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean nonCheck(String line) {
        return line.equals("");
    }

    private boolean lineCommentCheck(String line) {
        int i = 0;
        while (i < this.lineComments.size()) {
            if (line.startsWith(this.lineComments.get(i))) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.areaComments.size()) {
            AreaComment area = this.areaComments.get(i);
            String start = area.getStartString();
            String end = area.getEndString();
            int index = line.indexOf(start);
            if (index == 0 && line.indexOf(end, index) == line.length() - end.length()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private AreaComment areaCommentStartCheck(String line) {
        int i = 0;
        while (i < this.areaComments.size()) {
            AreaComment area = this.areaComments.get(i);
            String start = area.getStartString();
            String end = area.getEndString();
            int index = line.indexOf(start);
            if (index >= 0 && line.indexOf(end, index) < 0) {
                return area;
            }
            ++i;
        }
        return null;
    }

    private boolean areaCommentEndCheck(String line, AreaComment area) {
        String end = area.getEndString();
        return line.indexOf(end) >= 0;
    }

    public DiffSource cut(String source) {
        Matcher matcher;
        Pattern pattern;
        boolean isIgnore;
        String category;
        block9: {
            String line = null;
            category = "";
            isIgnore = false;
            BufferedReader reader = new BufferedReader(new StringReader(source));
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher2;
                        if (category.length() == 0 && (matcher2 = CATEGORY_PATTERN.matcher(line)).find()) {
                            category = matcher2.group(1);
                        }
                        if (!IGNORE_PATTERN.matcher(line).find()) continue;
                        isIgnore = true;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Util.close(reader);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Util.close(reader);
                throw throwable;
            }
            Util.close(reader);
        }
        for (String lineComment : this.lineComments) {
            pattern = Pattern.compile(String.valueOf(Pattern.quote(lineComment)) + ".+");
            matcher = pattern.matcher(source);
            source = matcher.replaceAll("");
        }
        for (AreaComment areaComment : this.areaComments) {
            pattern = Pattern.compile(String.valueOf(Pattern.quote(areaComment.getStartString())) + ".+?" + Pattern.quote(areaComment.getEndString()), 32);
            matcher = pattern.matcher(source);
            source = matcher.replaceAll("");
        }
        return new DiffSource(DiffCounterUtil.removeEmptyLines(source), isIgnore, category);
    }
}

