/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.StepCounter;
import jp.sf.amateras.stepcounter.StepCounterFactory;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.format.FormatterFactory;
import jp.sf.amateras.stepcounter.format.ResultFormatter;

public class Main {
    private File[] files;
    private ResultFormatter formatter;
    private OutputStream output = System.out;
    private boolean showDirectory = false;

    public void setShowDirectory(boolean showDirectory) {
        this.showDirectory = showDirectory;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public void setFormatter(ResultFormatter formatter) {
        this.formatter = formatter;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public void executeCount() throws IOException {
        if (this.formatter == null) {
            this.formatter = FormatterFactory.getFormatter("");
        }
        ArrayList<CountResult> list = new ArrayList<CountResult>();
        int i = 0;
        while (i < this.files.length) {
            CountResult[] results = this.count(this.files[i]);
            int j = 0;
            while (j < results.length) {
                list.add(results[j]);
                ++j;
            }
            ++i;
        }
        CountResult[] results = list.toArray(new CountResult[list.size()]);
        if (this.showDirectory) {
            CountResult[] countResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                CountResult result = countResultArray[n2];
                result.setFileName(this.getFileNameWithDir(result.getFile()));
                ++n2;
            }
        }
        this.output.write(this.formatter.format(results));
        this.output.flush();
        if (this.output != System.out) {
            this.output.close();
        }
    }

    private CountResult[] count(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            ArrayList<CountResult> list = new ArrayList<CountResult>();
            int i = 0;
            while (i < files.length) {
                CountResult[] results = this.count(files[i]);
                int j = 0;
                while (j < results.length) {
                    list.add(results[j]);
                    ++j;
                }
                ++i;
            }
            return list.toArray(new CountResult[list.size()]);
        }
        StepCounter counter = StepCounterFactory.getCounter(file.getName());
        if (counter != null) {
            CountResult result = counter.count(file, Util.getFileEncoding(file));
            return new CountResult[]{result};
        }
        return new CountResult[]{new CountResult(file, file.getName(), null, null, 0L, 0L, 0L)};
    }

    private String getFileNameWithDir(File file) throws IOException {
        if (file.isDirectory()) {
            return file.getName();
        }
        if (this.files == null || this.files.length == 0) {
            return file.getName();
        }
        String filePath = file.getCanonicalPath();
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String parentPath = f.getCanonicalPath();
            if (filePath.contains(parentPath)) {
                StringBuilder builder = new StringBuilder();
                builder.append('/');
                builder.append(f.getName());
                builder.append(filePath.substring(parentPath.length()).replaceAll("\\\\", "/"));
                return builder.toString();
            }
            ++n2;
        }
        return file.getName();
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            System.exit(0);
        }
        String format = null;
        String output = null;
        String encoding = null;
        String showDirectory = null;
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < args.length) {
            String[] dim;
            if (args[i].startsWith("-format=")) {
                dim = Util.split(args[i], "=");
                format = dim[1];
            } else if (args[i].startsWith("-output=")) {
                dim = Util.split(args[i], "=");
                output = dim[1];
            } else if (args[i].startsWith("-encoding=")) {
                dim = Util.split(args[i], "=");
                encoding = dim[1];
            } else if (args[i].startsWith("-showDirectory=")) {
                dim = Util.split(args[i], "=");
                showDirectory = dim[1];
            } else {
                fileList.add(new File(args[i]));
            }
            ++i;
        }
        Main main = new Main();
        main.setFiles(fileList.toArray(new File[fileList.size()]));
        main.setFormatter(FormatterFactory.getFormatter(format));
        if (output != null && !output.equals("")) {
            main.setOutput(new PrintStream(new FileOutputStream(new File(output))));
        }
        if (encoding != null) {
            Util.setFileEncoding(encoding);
        }
        if ("true".equalsIgnoreCase(showDirectory)) {
            main.setShowDirectory(true);
        }
        main.executeCount();
    }
}

