/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.StepCounter;
import jp.sf.amateras.stepcounter.diffcount.Cutter;
import jp.sf.amateras.stepcounter.diffcount.DiffCounterUtil;
import jp.sf.amateras.stepcounter.diffcount.DiffSource;

public class PythonCounter
implements StepCounter,
Cutter {
    private static Pattern CATEGORY_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]");
    private static Pattern IGNORE_PATTERN = Pattern.compile("\\[\\[IGNORE\\]\\]");
    private static Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile("#.+");
    private static final String DOCSTRING_DELIMITER = "\"\"\"";

    public CountResult count(File file, String charset) throws IOException {
        String charSetName = charset;
        if (charSetName == null) {
            charSetName = Charset.defaultCharset().name();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charSetName));
        String category = "";
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        try {
            String line = null;
            boolean areaFlag = false;
            boolean objectStartingFlag = true;
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                if (category.length() == 0 && (matcher = CATEGORY_PATTERN.matcher(line)).find()) {
                    category = matcher.group(1);
                }
                if (IGNORE_PATTERN.matcher(line).find()) {
                    return null;
                }
                String trimedLine = line.trim();
                if (areaFlag) {
                    ++comment;
                    if (!trimedLine.endsWith(DOCSTRING_DELIMITER)) continue;
                    areaFlag = false;
                    continue;
                }
                if (objectStartingFlag && trimedLine.startsWith(DOCSTRING_DELIMITER)) {
                    ++comment;
                    areaFlag = !trimedLine.endsWith(DOCSTRING_DELIMITER);
                    continue;
                }
                objectStartingFlag = false;
                if (trimedLine.length() == 0) {
                    ++non;
                    continue;
                }
                if (trimedLine.indexOf(35) >= 0) {
                    ++comment;
                    continue;
                }
                ++step;
                if (!trimedLine.startsWith("def ") && !trimedLine.startsWith("class ")) continue;
                objectStartingFlag = true;
            }
        }
        finally {
            reader.close();
        }
        return new CountResult(file, file.getName(), this.getFileType(), category, step, non, comment);
    }

    public String getFileType() {
        return "Python";
    }

    public DiffSource cut(String source) {
        String category = "";
        boolean isIgnore = false;
        String[] lines = source.split("\n");
        StringBuilder sb = new StringBuilder();
        boolean objectStartingFlag = false;
        boolean docStringFlag = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher matcher;
            String line = stringArray[n2];
            String trimedLine = line.trim();
            if (category.length() == 0 && (matcher = CATEGORY_PATTERN.matcher(line)).find()) {
                category = matcher.group(1);
            }
            if (IGNORE_PATTERN.matcher(line).find()) {
                isIgnore = true;
            }
            if (docStringFlag) {
                if (trimedLine.endsWith(DOCSTRING_DELIMITER)) {
                    docStringFlag = false;
                }
            } else if (objectStartingFlag && trimedLine.startsWith(DOCSTRING_DELIMITER)) {
                docStringFlag = !trimedLine.endsWith(DOCSTRING_DELIMITER);
            } else {
                objectStartingFlag = false;
                if (trimedLine.startsWith("def ") || trimedLine.startsWith("class ")) {
                    objectStartingFlag = true;
                }
                sb.append(line).append("\n");
            }
            ++n2;
        }
        source = sb.toString();
        Matcher matcher = SINGLE_LINE_COMMENT_PATTERN.matcher(source);
        source = matcher.replaceAll("");
        return new DiffSource(DiffCounterUtil.removeEmptyLines(source), isIgnore, category);
    }
}

