/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter;

import jp.sf.amateras.stepcounter.AreaComment;
import jp.sf.amateras.stepcounter.DefaultStepCounter;
import jp.sf.amateras.stepcounter.PythonCounter;
import jp.sf.amateras.stepcounter.StepCounter;

public class StepCounterFactory {
    private static DefaultStepCounter createJavaCounter(String name) {
        DefaultStepCounter counter = new DefaultStepCounter();
        counter.addLineComment("//");
        counter.addAreaComment(new AreaComment("/*", "*/"));
        counter.setFileType(name);
        return counter;
    }

    private static DefaultStepCounter createVBCounter(String name) {
        DefaultStepCounter counter = new DefaultStepCounter();
        counter.addLineComment("'");
        counter.addLineComment("REM");
        counter.setFileType(name);
        return counter;
    }

    private static DefaultStepCounter createShellCounter(String name) {
        DefaultStepCounter counter = new DefaultStepCounter();
        counter.addLineComment("#");
        counter.setFileType(name);
        return counter;
    }

    private static DefaultStepCounter createXMLCounter(String name) {
        DefaultStepCounter counter = new DefaultStepCounter();
        counter.addAreaComment(new AreaComment("<!--", "-->"));
        counter.setFileType(name);
        return counter;
    }

    private static DefaultStepCounter createListCounter(String name) {
        DefaultStepCounter counter = new DefaultStepCounter();
        counter.addLineComment(";");
        counter.setFileType(name);
        return counter;
    }

    public static StepCounter getCounter(String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith(".java")) {
            return StepCounterFactory.createJavaCounter("Java");
        }
        if (fileName.endsWith(".scala")) {
            return StepCounterFactory.createJavaCounter("Scala");
        }
        if (fileName.endsWith(".cpp") || fileName.endsWith(".cxx") || fileName.endsWith(".cc") || fileName.endsWith(".c") || fileName.endsWith(".m") || fileName.endsWith(".mm")) {
            return StepCounterFactory.createJavaCounter("C/C++/ObjC");
        }
        if (fileName.endsWith(".h") || fileName.endsWith(".hpp") || fileName.endsWith(".hxx")) {
            return StepCounterFactory.createJavaCounter("h");
        }
        if (fileName.endsWith(".cs")) {
            return StepCounterFactory.createJavaCounter("C#");
        }
        if (fileName.endsWith(".jsp")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("//");
            counter.addAreaComment(new AreaComment("/*", "*/"));
            counter.addAreaComment(new AreaComment("<%--", "--%>"));
            counter.addAreaComment(new AreaComment("<!--", "-->"));
            counter.setFileType("JSP");
            return counter;
        }
        if (fileName.endsWith(".php") || fileName.endsWith(".php3")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("//");
            counter.addAreaComment(new AreaComment("/*", "*/"));
            counter.addAreaComment(new AreaComment("<!--", "-->"));
            counter.setFileType("PHP");
            return counter;
        }
        if (fileName.endsWith(".asp") || fileName.endsWith(".asa")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("'");
            counter.addAreaComment(new AreaComment("<!--", "-->"));
            counter.setFileType("ASP");
            return counter;
        }
        if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            return StepCounterFactory.createXMLCounter("HTML");
        }
        if (fileName.endsWith(".xhtml")) {
            return StepCounterFactory.createXMLCounter("XHTML");
        }
        if (fileName.endsWith(".js")) {
            return StepCounterFactory.createJavaCounter("js");
        }
        if (fileName.endsWith(".json")) {
            return StepCounterFactory.createJavaCounter("JSON");
        }
        if (fileName.endsWith(".vbs")) {
            return StepCounterFactory.createVBCounter("vbs");
        }
        if (fileName.endsWith(".bas") || fileName.endsWith(".frm") || fileName.endsWith(".cls")) {
            return StepCounterFactory.createVBCounter("VB");
        }
        if (fileName.endsWith(".vb")) {
            return StepCounterFactory.createVBCounter("VB.NET");
        }
        if (fileName.endsWith(".pl") || fileName.endsWith(".pm")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("#");
            counter.addAreaComment(new AreaComment("=pod", "=cut"));
            counter.setFileType("Perl");
            return counter;
        }
        if (fileName.endsWith(".py")) {
            return new PythonCounter();
        }
        if (fileName.endsWith(".rb")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("#");
            counter.addAreaComment(new AreaComment("=begin", "=end"));
            counter.setFileType("Ruby");
            return counter;
        }
        if (fileName.endsWith(".tcl")) {
            return StepCounterFactory.createShellCounter("Tcl");
        }
        if (fileName.endsWith(".sql")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("#");
            counter.addLineComment("--");
            counter.addLineComment("REM");
            counter.addAreaComment(new AreaComment("/*", "*/"));
            counter.setFileType("SQL");
            return counter;
        }
        if (fileName.endsWith(".cfm")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addAreaComment(new AreaComment("<!--", "-->"));
            counter.addAreaComment(new AreaComment("<!---", "--->"));
            counter.setFileType("CFM");
            return counter;
        }
        if (fileName.endsWith(".properties")) {
            return StepCounterFactory.createShellCounter("Properties");
        }
        if (fileName.endsWith(".xml") || fileName.endsWith(".dicon")) {
            return StepCounterFactory.createXMLCounter("XML");
        }
        if (fileName.endsWith(".xsl")) {
            return StepCounterFactory.createXMLCounter("XSLT");
        }
        if (fileName.endsWith(".xi")) {
            return StepCounterFactory.createXMLCounter("Xi");
        }
        if (fileName.endsWith(".dtd")) {
            return StepCounterFactory.createXMLCounter("DTD");
        }
        if (fileName.endsWith(".tld")) {
            return StepCounterFactory.createXMLCounter("TLD");
        }
        if (fileName.endsWith(".xsd")) {
            return StepCounterFactory.createXMLCounter("XMLSchema");
        }
        if (fileName.endsWith(".bat")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("REM");
            counter.setFileType("BAT");
            return counter;
        }
        if (fileName.endsWith(".css")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addAreaComment(new AreaComment("/*", "*/"));
            counter.setFileType("CSS");
            return counter;
        }
        if (fileName.endsWith(".l") || fileName.endsWith(".el") || fileName.endsWith(".cl")) {
            return StepCounterFactory.createListCounter("Lisp");
        }
        if (fileName.endsWith(".clj")) {
            return StepCounterFactory.createListCounter("Clojure");
        }
        if (fileName.endsWith(".scm")) {
            return StepCounterFactory.createListCounter("Scheme");
        }
        if (fileName.endsWith(".st")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addAreaComment(new AreaComment("\"", "\""));
            counter.setFileType("Smalltalk");
            return counter;
        }
        if (fileName.endsWith(".vm") || fileName.endsWith(".vsl")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("##");
            counter.setFileType("Velocity");
            return counter;
        }
        if (fileName.endsWith(".ini")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment(";");
            counter.setFileType("INI");
            return counter;
        }
        if (fileName.endsWith(".lua")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("--");
            counter.addAreaComment(new AreaComment("--[[", "]]"));
            counter.addAreaComment(new AreaComment("--[===[", "]===]"));
            counter.setFileType("Lua");
            return counter;
        }
        if (fileName.endsWith(".hs")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("--");
            counter.addAreaComment(new AreaComment("{-", "-}"));
            counter.setFileType("Haskell");
            return counter;
        }
        if (fileName.endsWith(".f") || fileName.endsWith(".for") || fileName.endsWith(".ftn")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("*");
            counter.setFileType("Fortran");
            return counter;
        }
        if (fileName.endsWith(".f90") || fileName.endsWith(".f95")) {
            DefaultStepCounter counter = new DefaultStepCounter();
            counter.addLineComment("!");
            counter.setFileType("Fortran");
            return counter;
        }
        if (fileName.equals("Makefile")) {
            return StepCounterFactory.createShellCounter("Makefile");
        }
        if (fileName.endsWith(".as")) {
            return StepCounterFactory.createJavaCounter(".as");
        }
        if (fileName.endsWith(".mxml")) {
            return StepCounterFactory.createXMLCounter(".mxml");
        }
        return null;
    }
}

