/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import jp.sf.amateras.stepcounter.FileEncodingDetector;

public class Util {
    private static String fileEncoding = null;
    private static FileEncodingDetector fileEncodingDetector = null;

    public static String[] split(String str, String del) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        int index = 0;
        while ((index = str.indexOf(del, pos)) != -1) {
            list.add(str.substring(pos, index));
            pos = index + del.length();
        }
        list.add(str.substring(pos, str.length()));
        return list.toArray(new String[list.size()]);
    }

    public static String substring(String str, int length) {
        String resultStr = null;
        int zenCnt = 0;
        int loopCnt = length;
        byte[] resBytes = new byte[length];
        byte[] bytes = str.getBytes();
        if (bytes.length <= length) {
            return str;
        }
        int i = 0;
        while (i < length) {
            if (bytes[i] < 0) {
                ++zenCnt;
            }
            ++i;
        }
        if (zenCnt % 2 == 1) {
            --loopCnt;
        }
        i = 0;
        while (i < loopCnt) {
            resBytes[i] = bytes[i];
            ++i;
        }
        resultStr = new String(resBytes);
        return resultStr;
    }

    public static int getByteLength(String str) {
        try {
            byte[] bytes = str.getBytes();
            return bytes.length;
        }
        catch (Exception ex) {
            return str.getBytes().length;
        }
    }

    public static String escapeXML(String str) {
        str.replaceAll("&", "&amp;");
        str.replaceAll("<", "&gt;");
        str.replaceAll(">", "&lt;");
        str.replaceAll("\"", "&quot;");
        return str;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFileEncodingDetector(FileEncodingDetector detector) {
        fileEncodingDetector = detector;
    }

    public static void setFileEncoding(String encoding) {
        fileEncoding = encoding;
    }

    public static String getFileEncoding(File file) {
        String encoding;
        if (fileEncoding != null) {
            return fileEncoding;
        }
        if (fileEncodingDetector != null && (encoding = fileEncodingDetector.getEncoding(file)) != null) {
            return encoding;
        }
        return System.getProperty("file.encoding");
    }
}

