/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.ant;

import java.io.File;
import java.io.FileOutputStream;
import jp.sf.amateras.stepcounter.diffcount.Main;
import jp.sf.amateras.stepcounter.diffcount.renderer.RendererFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DiffCounterTask
extends Task {
    private String srcdir = null;
    private String olddir = null;
    private String format = null;
    private String output = null;
    private String encoding = null;

    public void execute() throws BuildException {
        if (RendererFactory.getRenderer(this.format) == null) {
            throw new BuildException("format " + this.format + " is invalid!");
        }
        if (this.srcdir == null || this.srcdir.length() == 0) {
            throw new BuildException("srcdir is required!");
        }
        if (!new File(this.srcdir).isDirectory()) {
            throw new BuildException("srcdir '" + this.srcdir + "' is not directory!");
        }
        if (this.olddir == null || this.olddir.length() == 0) {
            throw new BuildException("olddir is required!");
        }
        if (!new File(this.olddir).isDirectory()) {
            throw new BuildException("olddir '" + this.olddir + "' is not directory!");
        }
        try {
            File basedir = this.getProject().getBaseDir();
            Main main = new Main();
            main.setFormat(this.format);
            if (this.output != null && this.output.length() != 0) {
                main.setOutput(new FileOutputStream(this.output));
            }
            main.setEncoding(this.encoding);
            main.setSrcdir(new File(basedir, this.srcdir));
            main.setOlddir(new File(basedir, this.olddir));
            main.executeCount();
            if (this.output != null && !this.output.equals("")) {
                System.out.println(String.valueOf(new File(this.output).getAbsolutePath()) + "\u306b\u30ab\u30a6\u30f3\u30c8\u7d50\u679c\u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
    }

    public void setOlddir(String olddir) {
        this.olddir = olddir;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

