/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.StepCounter;
import jp.sf.amateras.stepcounter.StepCounterFactory;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.format.FormatterFactory;
import jp.sf.amateras.stepcounter.format.ResultFormatter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;

public class StepCounterTask
extends Task {
    private File output;
    private String format = "";
    private String encoding;
    private List<ResourceCollection> rcs = new ArrayList<ResourceCollection>();
    private boolean showDirectory = false;
    private boolean directoryAsCategory = false;
    private boolean defaultExcludes = true;
    private boolean failonerror = true;

    public void setOutput(File output) {
        this.output = output;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public void setShowDirectory(boolean showDirectory) {
        this.showDirectory = showDirectory;
    }

    public void setDirectoryAsCategory(boolean directoryAsCategory) {
        this.directoryAsCategory = directoryAsCategory;
    }

    public void setDefaultexcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void execute() throws BuildException {
        ResultFormatter formatter = FormatterFactory.getFormatter(this.format);
        if (this.encoding != null) {
            Util.setFileEncoding(this.encoding);
        }
        FilterOutputStream out = null;
        try {
            try {
                FileSet fs;
                if (this.output != null) {
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(this.output));
                    }
                    catch (FileNotFoundException e) {
                        throw new BuildException("One of tofile or todir must be set.", (Throwable)e);
                    }
                } else {
                    out = System.out;
                }
                LinkedHashMap<FileSet, ResourceCollection> fsList = new LinkedHashMap<FileSet, ResourceCollection>();
                for (ResourceCollection rc : this.rcs) {
                    if (rc instanceof FileList && rc.isFilesystemOnly()) {
                        FileList fl = (FileList)rc;
                        fs = new FileSet();
                        fs.setDir(fl.getDir(this.getProject()));
                        fs.appendIncludes(fl.getFiles(this.getProject()));
                        fsList.put(fs, rc);
                        continue;
                    }
                    if (rc instanceof FileSet && rc.isFilesystemOnly()) {
                        fsList.put((FileSet)rc, rc);
                        continue;
                    }
                    throw new BuildException("Only FileSystem resources are supported.");
                }
                ArrayList<CountResult> results = new ArrayList<CountResult>();
                for (Map.Entry entry : fsList.entrySet()) {
                    String basePath;
                    fs = (FileSet)entry.getKey();
                    fs.setDefaultexcludes(this.defaultExcludes);
                    DirectoryScanner ds = null;
                    try {
                        ds = fs.getDirectoryScanner(this.getProject());
                    }
                    catch (BuildException e) {
                        if (this.failonerror || !this.getMessage((Exception)((Object)e)).endsWith(" does not exist.")) {
                            throw e;
                        }
                        this.log("Warning: " + this.getMessage((Exception)((Object)e)), 0);
                        continue;
                    }
                    File baseDir = fs.getDir(this.getProject());
                    if (!baseDir.exists()) {
                        throw new BuildException("basedir \"" + baseDir.getPath() + "\" does not exist!");
                    }
                    try {
                        basePath = baseDir.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new BuildException("I/O Error: " + baseDir, (Throwable)e);
                    }
                    String[] stringArray = ds.getIncludedFiles();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        File file = new File(baseDir, name);
                        try {
                            CountResult result = this.count(file);
                            if (this.showDirectory) {
                                name = file.getCanonicalPath();
                                if (name.startsWith(basePath)) {
                                    name = name.substring(basePath.length());
                                }
                                name = name.replace('\\', '/');
                                result.setFileName(name);
                            }
                            if (this.directoryAsCategory) {
                                result.setCategory(baseDir.getName());
                            }
                            results.add(result);
                        }
                        catch (IOException e) {
                            if (this.failonerror) {
                                throw new BuildException("I/O Error: " + file, (Throwable)e);
                            }
                            this.log("Warning: " + this.getMessage(e), 0);
                        }
                        ++n2;
                    }
                }
                this.log(fsList.size() + " \u8d77\u70b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea / " + results.size() + " \u30d5\u30a1\u30a4\u30eb");
                ((OutputStream)out).write(formatter.format(results.toArray(new CountResult[results.size()])));
                ((OutputStream)out).flush();
                if (this.output != null) {
                    this.log(String.valueOf(this.output.getAbsolutePath()) + " \u306b\u30ab\u30a6\u30f3\u30c8\u7d50\u679c\u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
                }
            }
            catch (IOException e) {
                throw new BuildException("I/O Error", (Throwable)e);
            }
        }
        finally {
            try {
                if (out != null && this.output != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                throw new BuildException("I/O Error", (Throwable)e);
            }
        }
    }

    private CountResult count(File file) throws IOException {
        StepCounter counter = StepCounterFactory.getCounter(file.getName());
        if (counter != null) {
            return counter.count(file, Util.getFileEncoding(file));
        }
        return new CountResult(file, file.getName(), null, null, 0L, 0L, 0L);
    }

    private String getMessage(Exception ex) {
        return ex.getMessage() == null ? ex.toString() : ex.getMessage();
    }
}

