/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount;

import java.io.File;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.diffcount.Cutter;
import jp.sf.amateras.stepcounter.diffcount.CutterFactory;
import jp.sf.amateras.stepcounter.diffcount.DiffCounterUtil;
import jp.sf.amateras.stepcounter.diffcount.DiffSource;
import jp.sf.amateras.stepcounter.diffcount.diff.DiffEngine;
import jp.sf.amateras.stepcounter.diffcount.diff.IDiffHandler;
import jp.sf.amateras.stepcounter.diffcount.object.AbstractDiffResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFileResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffStatus;

public class DiffCounter {
    public static DiffFolderResult count(File oldRoot, File newRoot) {
        DiffFolderResult root = new DiffFolderResult(null);
        root.setName(newRoot.getName());
        DiffCounter.diffFolder(root, oldRoot, newRoot);
        return root;
    }

    private static void diffFolder(DiffFolderResult parent, File oldFolder, File newFolder) {
        int n;
        int n2;
        File[] fileArray;
        boolean found;
        File[] newFiles;
        File[] oldFiles = oldFolder.listFiles();
        if (oldFiles == null) {
            oldFiles = new File[]{};
        }
        File[] fileArray2 = newFiles = newFolder.listFiles();
        int n3 = newFiles.length;
        int n4 = 0;
        while (n4 < n3) {
            File newFile = fileArray2[n4];
            if (!DiffCounterUtil.isIgnore(newFile)) {
                found = false;
                fileArray = oldFiles;
                n2 = oldFiles.length;
                n = 0;
                while (n < n2) {
                    File oldFile = fileArray[n];
                    if (newFile.getName().equals(oldFile.getName())) {
                        AbstractDiffResult result = DiffCounter.createDiffResult(parent, oldFile, newFile, Util.getFileEncoding(newFile), DiffStatus.MODIFIED);
                        if (result != null) {
                            parent.addChild(result);
                        }
                        found = true;
                        break;
                    }
                    ++n;
                }
                if (!found) {
                    AbstractDiffResult result = DiffCounter.createDiffResult(parent, null, newFile, Util.getFileEncoding(newFile), DiffStatus.ADDED);
                    parent.addChild(result);
                }
                if (newFile.isDirectory()) {
                    DiffFolderResult newParent = (DiffFolderResult)parent.getChildren().get(parent.getChildren().size() - 1);
                    DiffCounter.diffFolder(newParent, new File(oldFolder, newFile.getName()), newFile);
                }
            }
            ++n4;
        }
        fileArray2 = oldFiles;
        n3 = oldFiles.length;
        n4 = 0;
        while (n4 < n3) {
            File oldFile = fileArray2[n4];
            if (!DiffCounterUtil.isIgnore(oldFile)) {
                found = false;
                fileArray = newFiles;
                n2 = newFiles.length;
                n = 0;
                while (n < n2) {
                    File newFile = fileArray[n];
                    if (oldFile.getName().equals(newFile.getName())) {
                        found = true;
                        break;
                    }
                    ++n;
                }
                if (!found) {
                    parent.addChild(DiffCounter.createDiffResult(parent, oldFile, null, Util.getFileEncoding(oldFile), DiffStatus.REMOVED));
                }
            }
            ++n4;
        }
    }

    private static AbstractDiffResult createDiffResult(DiffFolderResult parent, File oldFile, File newFile, String charset, DiffStatus status) {
        if (newFile != null && newFile.isFile()) {
            DiffFileResult diffResult;
            Cutter cutter = CutterFactory.getCutter(newFile);
            if (cutter != null) {
                diffResult = DiffCounter.createDiffFileResult(parent, oldFile, newFile, charset, status, cutter);
            } else {
                diffResult = new DiffFileResult(parent);
                diffResult.setName(newFile.getName());
                diffResult.setStatus(DiffStatus.UNSUPPORTED);
                diffResult.setAddCount(0);
                diffResult.setFileType(CutterFactory.getFileType(newFile));
            }
            return diffResult;
        }
        if (oldFile != null && oldFile.isFile()) {
            DiffFileResult diffResult = new DiffFileResult(parent);
            diffResult.setName(oldFile.getName());
            diffResult.setStatus(status);
            diffResult.setFileType(CutterFactory.getFileType(oldFile));
            Cutter cutter = CutterFactory.getCutter(oldFile);
            if (cutter != null && status == DiffStatus.REMOVED) {
                DiffSource source = cutter.cut(DiffCounterUtil.getSource(oldFile, charset));
                if (source.isIgnore()) {
                    return null;
                }
                diffResult.setDelCount(DiffCounterUtil.split(source.getSource()).length);
                diffResult.setCategory(source.getCategory());
            }
            return diffResult;
        }
        if (newFile != null && newFile.isDirectory()) {
            DiffFolderResult diffResult = new DiffFolderResult(parent);
            diffResult.setName(newFile.getName());
            diffResult.setStatus(status);
            return diffResult;
        }
        if (oldFile != null && oldFile.isDirectory()) {
            DiffFolderResult diffResult = new DiffFolderResult(parent);
            diffResult.setName(oldFile.getName());
            diffResult.setStatus(status);
            return diffResult;
        }
        return null;
    }

    private static DiffFileResult createDiffFileResult(DiffFolderResult parent, File oldFile, File newFile, String charset, DiffStatus status, Cutter cutter) {
        DiffFileResult diffResult = new DiffFileResult(parent);
        diffResult.setFileType(CutterFactory.getFileType(newFile));
        diffResult.setName(newFile.getName());
        diffResult.setStatus(status);
        if (status == DiffStatus.ADDED) {
            DiffSource source = cutter.cut(DiffCounterUtil.getSource(newFile, charset));
            if (source.isIgnore()) {
                return null;
            }
            diffResult.setAddCount(DiffCounterUtil.split(source.getSource()).length);
            diffResult.setCategory(source.getCategory());
        } else if (status == DiffStatus.MODIFIED) {
            DiffSource oldSource = cutter.cut(DiffCounterUtil.getSource(oldFile, charset));
            DiffSource newSource = cutter.cut(DiffCounterUtil.getSource(newFile, charset));
            if (newSource.isIgnore()) {
                return null;
            }
            DiffCountHandler handler = new DiffCountHandler();
            DiffEngine engine = new DiffEngine(handler, oldSource.getSource(), newSource.getSource());
            engine.doDiff();
            diffResult.setAddCount(handler.getAddCount());
            diffResult.setDelCount(handler.getDelCount());
            diffResult.setCategory(newSource.getCategory());
            if (handler.getAddCount() == 0) {
                diffResult.setStatus(DiffStatus.NONE);
            }
        } else if (status == DiffStatus.REMOVED) {
            DiffSource source = cutter.cut(DiffCounterUtil.getSource(oldFile, charset));
            if (source.isIgnore()) {
                return null;
            }
            diffResult.setDelCount(DiffCounterUtil.split(source.getSource()).length);
            diffResult.setCategory(source.getCategory());
        } else {
            diffResult = null;
        }
        return diffResult;
    }

    private static class DiffCountHandler
    implements IDiffHandler {
        private int addCount = 0;
        private int delCount = 0;

        private DiffCountHandler() {
        }

        public void add(String text) {
            ++this.addCount;
        }

        public void delete(String text) {
            ++this.delCount;
        }

        public void match(String text) {
        }

        public int getAddCount() {
            return this.addCount;
        }

        public int getDelCount() {
            return this.delCount;
        }
    }
}

