/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.sf.amateras.stepcounter.diffcount.object.AbstractDiffResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFileResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCounterUtil {
    public static boolean isIgnore(File file) {
        String name = file.getName();
        if (name.equals("CVS")) {
            return true;
        }
        if (name.equals(".svn")) {
            return true;
        }
        if (name.equals(".hg")) {
            return true;
        }
        return name.equals(".git");
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(date);
    }

    public static String removeEmptyLines(String source) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = DiffCounterUtil.split(source);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.matches("\\s*")) {
                sb.append(line).append("\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String[] split(String source) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '\n') {
                lines.add(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String getSource(File file, String charset) {
        if (file == null) {
            return "";
        }
        try {
            FileInputStream in = new FileInputStream(file);
            int size = in.available();
            byte[] buf = new byte[size];
            in.read(buf);
            in.close();
            String source = new String(buf, charset);
            source = source.replaceAll("\r\n", "\n");
            source = source.replaceAll("\r", "\n");
            return source;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<DiffFileResult> convertToList(DiffFolderResult folderResult) {
        return new ArrayList<DiffFileResult>(DiffCounterUtil.convertToMap(folderResult).values());
    }

    private static Map<String, DiffFileResult> convertToMap(DiffFolderResult folderResult) {
        TreeMap<String, DiffFileResult> map = new TreeMap<String, DiffFileResult>();
        List<AbstractDiffResult> children = folderResult.getChildren();
        for (AbstractDiffResult child : children) {
            if (child instanceof DiffFolderResult) {
                Map<String, DiffFileResult> childMap = DiffCounterUtil.convertToMap((DiffFolderResult)child);
                map.putAll(childMap);
                continue;
            }
            if (!(child instanceof DiffFileResult)) continue;
            DiffFileResult fileResult = (DiffFileResult)child;
            map.put(fileResult.getPath(), fileResult);
        }
        return map;
    }
}

