/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.diffcount.DiffCounter;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;
import jp.sf.amateras.stepcounter.diffcount.renderer.Renderer;
import jp.sf.amateras.stepcounter.diffcount.renderer.RendererFactory;

public class Main {
    private OutputStream output = System.out;
    private File srcdir = null;
    private File olddir = null;
    private String format = null;
    private String encoding = null;

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setOlddir(File olddir) {
        this.olddir = olddir;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void executeCount() {
        try {
            Renderer renderer;
            if (this.format == null || this.format.length() == 0) {
                this.format = "text";
            }
            if (this.encoding != null && this.encoding.length() > 0) {
                Util.setFileEncoding(this.encoding);
            }
            if ((renderer = RendererFactory.getRenderer(this.format)) == null) {
                throw new RuntimeException(String.valueOf(this.format) + " is invalid format!");
            }
            DiffFolderResult result = DiffCounter.count(this.olddir, this.srcdir);
            byte[] bytes = renderer.render(result);
            try {
                this.output.write(bytes);
            }
            finally {
                if (this.output != System.out) {
                    this.output.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            System.exit(0);
        }
        String format = null;
        String output = null;
        String encoding = null;
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < args.length) {
            String[] dim;
            if (args[i].startsWith("-format=")) {
                dim = Util.split(args[i], "=");
                format = dim[1];
            } else if (args[i].startsWith("-output=")) {
                dim = Util.split(args[i], "=");
                output = dim[1];
            } else if (args[i].startsWith("-encoding=")) {
                dim = Util.split(args[i], "=");
                encoding = dim[1];
            } else {
                fileList.add(new File(args[i]));
            }
            ++i;
        }
        if (fileList.size() == 0) {
            System.err.println("Directory which contains current source tree is not specified.");
            System.exit(1);
        }
        if (!((File)fileList.get(0)).isDirectory()) {
            System.err.println("'" + ((File)fileList.get(0)).getAbsolutePath() + "' is not directory.");
            System.exit(1);
        }
        if (fileList.size() == 1) {
            System.err.println("Directory to compare is not specified.");
            System.exit(1);
        }
        if (!((File)fileList.get(1)).isDirectory()) {
            System.err.println("'" + ((File)fileList.get(1)).getAbsolutePath() + "' is not directory.");
            System.exit(1);
        }
        Main main = new Main();
        main.setFormat(format);
        if (output != null && output.length() != 0) {
            main.setOutput(new FileOutputStream(output));
        }
        main.setEncoding(encoding);
        main.setSrcdir((File)fileList.get(0));
        main.setOlddir((File)fileList.get(1));
        main.executeCount();
    }
}

