/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount.diff;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.InsertDelta;
import difflib.Patch;
import java.util.Arrays;
import java.util.List;
import jp.sf.amateras.stepcounter.diffcount.diff.IDiffHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffEngine {
    private IDiffHandler handler;
    private List<String> text1;
    private List<String> text2;

    public DiffEngine(IDiffHandler handler, String text1, String text2) {
        if (text1 == null) {
            text1 = "";
        }
        if (text2 == null) {
            text2 = "";
        }
        this.handler = handler;
        this.text1 = DiffEngine.splitLine(text1);
        this.text2 = DiffEngine.splitLine(text2);
    }

    public void doDiff() {
        Patch rev = DiffUtils.diff(this.text1, this.text2);
        int count1 = 0;
        int count2 = 0;
        for (Delta delta : rev.getDeltas()) {
            Chunk orgChunk = delta.getOriginal();
            Chunk revChunk = delta.getRevised();
            while (count1 != orgChunk.getPosition()) {
                this.handler.match(this.text1.get(count1));
                ++count1;
            }
            count1 = orgChunk.getPosition();
            count2 = revChunk.getPosition();
            if (delta instanceof InsertDelta) {
                while (count2 <= revChunk.last()) {
                    this.handler.add(this.text2.get(count2));
                    ++count2;
                }
            } else if (delta instanceof DeleteDelta) {
                while (count1 <= orgChunk.last()) {
                    this.handler.delete(this.text1.get(count1));
                    ++count1;
                }
            } else if (delta instanceof ChangeDelta) {
                while (count1 <= orgChunk.last()) {
                    this.handler.delete(this.text1.get(count1));
                    ++count1;
                }
                while (count2 <= revChunk.last()) {
                    this.handler.add(this.text2.get(count2));
                    ++count2;
                }
            }
            count1 = orgChunk.last() + 1;
            count2 = revChunk.last() + 1;
        }
        while (this.text2.size() > count2) {
            this.handler.match(this.text2.get(count2));
            ++count2;
        }
    }

    private static List<String> splitLine(String text) {
        return Arrays.asList(text.split("\r?\n|\r"));
    }
}

