/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sf.amateras.stepcounter.diffcount.FileComparator;
import jp.sf.amateras.stepcounter.diffcount.object.AbstractDiffResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFolderResult
extends AbstractDiffResult {
    private List<AbstractDiffResult> children = new ArrayList<AbstractDiffResult>();

    public DiffFolderResult(DiffFolderResult parent) {
        super(parent);
    }

    public DiffFolderResult(String name, DiffStatus status, DiffFolderResult parent) {
        super(name, status, parent);
    }

    public void addChild(AbstractDiffResult child) {
        this.children.add(child);
    }

    public List<AbstractDiffResult> getChildren() {
        return this.children;
    }

    public List<AbstractDiffResult> getSortedChildren() {
        ArrayList<AbstractDiffResult> list = new ArrayList<AbstractDiffResult>(this.getChildren());
        Collections.sort(list, new FileComparator());
        return list;
    }

    @Override
    public DiffStatus getStatus() {
        DiffStatus status = super.getStatus();
        if (status == DiffStatus.REMOVED || status == DiffStatus.ADDED) {
            return status;
        }
        for (AbstractDiffResult obj : this.getChildren()) {
            DiffStatus childStatus = obj.getStatus();
            if (childStatus == DiffStatus.NONE) continue;
            return DiffStatus.MODIFIED;
        }
        return DiffStatus.NONE;
    }

    @Override
    protected String render(int nest) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < nest) {
            sb.append(" ");
            ++i;
        }
        sb.append(this.getName()).append("/");
        if (this.getStatus() != null) {
            sb.append("[").append((Object)this.getStatus()).append("]");
        }
        sb.append(" +").append(this.getAddCount());
        sb.append(" -").append(this.getDelCount()).append("\n");
        for (AbstractDiffResult obj : this.getSortedChildren()) {
            sb.append(obj.render(nest + 1)).append("\n");
        }
        return sb.toString().replaceFirst("\n$", "");
    }

    @Override
    public int getAddCount() {
        int addCount = 0;
        for (AbstractDiffResult obj : this.getChildren()) {
            addCount += obj.getAddCount();
        }
        return addCount;
    }

    @Override
    public int getDelCount() {
        int delCount = 0;
        for (AbstractDiffResult obj : this.getChildren()) {
            delCount += obj.getDelCount();
        }
        return delCount;
    }
}

