/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount.renderer;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.diffcount.DiffCounterUtil;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;
import jp.sf.amateras.stepcounter.diffcount.renderer.Renderer;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.template.FPTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRenderer
implements Renderer {
    @Override
    public byte[] render(DiffFolderResult root) {
        try {
            InputStream in = ExcelRenderer.class.getResourceAsStream("DiffExcelFormat.xls");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("results", DiffCounterUtil.convertToList(root));
            data.put("totalAdd", root.getAddCount());
            data.put("totalDel", root.getDelCount());
            return ExcelRenderer.merge(in, data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] merge(InputStream in, Map<String, Object> data) throws Exception {
        HSSFWorkbook wb;
        FPTemplate template = new FPTemplate();
        try {
            wb = template.process(in, data);
        }
        finally {
            Util.close(in);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wb.write(out);
        return out.toByteArray();
    }
}

