/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount.renderer;

import java.util.Date;
import jp.sf.amateras.stepcounter.diffcount.DiffCounterUtil;
import jp.sf.amateras.stepcounter.diffcount.object.AbstractDiffResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;
import jp.sf.amateras.stepcounter.diffcount.renderer.Renderer;

public class HTMLRenderer
implements Renderer {
    public byte[] render(DiffFolderResult root) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("<title>\u5909\u66f4\u30b9\u30c6\u30c3\u30d7\u6570</title>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("function switchDir(dirId){\n");
        sb.append("  var trList = document.getElementsByTagName('tr');\n");
        sb.append("  for(var i=0;i<trList.length;i++){\n");
        sb.append("    var className = trList[i].className;\n");
        sb.append("    if(className != null && className.indexOf(dirId) == 0){\n");
        sb.append("      if(trList[i].style.display == 'none'){\n");
        sb.append("        if(className == dirId){\n");
        sb.append("          trList[i].style.display = '';\n");
        sb.append("        }\n");
        sb.append("      } else {\n");
        sb.append("        trList[i].style.display = 'none';\n");
        sb.append("      }\n");
        sb.append("    }\n");
        sb.append("  }\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("function showAll(){\n");
        sb.append("  var trList = document.getElementsByTagName('tr');\n");
        sb.append("  for(var i=0;i<trList.length;i++){\n");
        sb.append("    if(trList[i].className != ''){\n");
        sb.append("      trList[i].style.display = '';\n");
        sb.append("    }\n");
        sb.append("  }\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("function hideAll(){\n");
        sb.append("  var trList = document.getElementsByTagName('tr');\n");
        sb.append("  for(var i=0;i<trList.length;i++){\n");
        sb.append("    if(trList[i].className != ''){\n");
        sb.append("      trList[i].style.display = 'none';\n");
        sb.append("    }\n");
        sb.append("  }\n");
        sb.append("}\n");
        sb.append("</script>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("\u5b9f\u884c\u6642\u523b\uff1a").append(DiffCounterUtil.formatDate(new Date())).append("\n");
        sb.append("<input type=\"button\" onclick=\"showAll();\" value=\"\u3059\u3079\u3066\u5c55\u958b\">");
        sb.append("<input type=\"button\" onclick=\"hideAll();\" value=\"\u3059\u3079\u3066\u53ce\u7d0d\">");
        sb.append("<table border=\"1\" width=\"100%\">\n");
        sb.append("<tr>");
        sb.append("<th width=\"80%\">\u540d\u524d</th><th width=\"10%\">\u72b6\u614b</th><th width=\"10%\">\u8ffd\u52a0\u30fb\u5909\u66f4\u884c\u6570</th><th>\u524a\u9664\u884c\u6570</th>");
        sb.append("</tr>\n");
        for (AbstractDiffResult obj : root.getSortedChildren()) {
            this.renderLine(null, obj, sb, 0);
        }
        sb.append("</table>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString().getBytes();
    }

    private void renderLine(DiffFolderResult parent, AbstractDiffResult obj, StringBuilder sb, int nest) {
        if (obj instanceof DiffFolderResult && nest == 0) {
            sb.append("<tr>");
        } else {
            sb.append("<tr class=\"").append(parent.getClassName()).append("\" style=\"display: none;\">");
        }
        sb.append("<td>");
        int i = 0;
        while (i < nest) {
            sb.append("&nbsp;");
            ++i;
        }
        if (obj instanceof DiffFolderResult) {
            sb.append("<a href=\"javascript:switchDir('").append(obj.getClassName()).append("')\">");
            sb.append(String.valueOf(obj.getName()) + "/");
            sb.append("</a>");
        } else {
            sb.append(obj.getName());
        }
        sb.append("</td>");
        sb.append("<td>");
        sb.append((Object)obj.getStatus());
        sb.append("</td>");
        sb.append("<td style=\"text-align: right;\">");
        sb.append(obj.getAddCount());
        sb.append("</td>");
        sb.append("<td style=\"text-align: right;\">");
        sb.append(obj.getDelCount());
        sb.append("</td>");
        sb.append("</tr>\n");
        if (obj instanceof DiffFolderResult) {
            DiffFolderResult folder = (DiffFolderResult)obj;
            for (AbstractDiffResult child : folder.getSortedChildren()) {
                this.renderLine(folder, child, sb, nest + 1);
            }
        }
    }
}

