/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.diffcount.renderer.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.sf.amateras.stepcounter.diffcount.DiffCounter;
import jp.sf.amateras.stepcounter.diffcount.object.AbstractDiffResult;
import jp.sf.amateras.stepcounter.diffcount.object.DiffFolderResult;
import jp.sf.amateras.stepcounter.diffcount.renderer.gui.DiffCountTreeTableModel;
import org.dyno.visual.swing.layouts.Bilateral;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;
import org.dyno.visual.swing.layouts.Trailing;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;

public class DiffCountFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JLabel jLabel0;
    private JButton browseOldRoot;
    private JLabel jLabel1;
    private JButton browseNewRoot;
    private JTextField oldRoot;
    private JTextField newRoot;
    private JButton executeDiffCount;
    private JXTreeTable resultTable;
    private JScrollPane jScrollPane0;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    public DiffCountFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getJLabel0(), new Constraints(new Leading(12, 12, 12), new Leading(12, 12, 12)));
        this.add((Component)this.getJTextField0(), new Constraints(new Bilateral(123, 82, 4), new Leading(10, 12, 12)));
        this.add((Component)this.getBrowseOldRoot(), new Constraints(new Trailing(12, 129, 129), new Leading(8, 12, 12)));
        this.add((Component)this.getJLabel1(), new Constraints(new Leading(12, 100, 100), new Leading(38, 12, 12)));
        this.add((Component)this.getJTextField1(), new Constraints(new Bilateral(123, 82, 6), new Leading(35, 12, 12)));
        this.add((Component)this.getBrowseNewRoot(), new Constraints(new Trailing(12, 131, 131), new Leading(34, 12, 12)));
        this.add((Component)this.getExecuteDiffCount(), new Constraints(new Trailing(12, 12, 12), new Leading(63, 12, 12)));
        this.add((Component)this.getJScrollPane0(), new Constraints(new Bilateral(12, 12, 23), new Bilateral(90, 12, 23)));
        this.setSize(475, 258);
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTable0());
        }
        return this.jScrollPane0;
    }

    private JXTreeTable getJTable0() {
        if (this.resultTable == null) {
            this.resultTable = new JXTreeTable(new DiffCountTreeTableModel());
            this.resultTable.setEditable(false);
        }
        return this.resultTable;
    }

    private JButton getExecuteDiffCount() {
        if (this.executeDiffCount == null) {
            this.executeDiffCount = new JButton();
            this.executeDiffCount.setText("\u30b9\u30c6\u30c3\u30d7\u6570\u306e\u5dee\u5206\u3092\u6e2c\u5b9a");
            this.executeDiffCount.setEnabled(false);
            this.executeDiffCount.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DiffCountFrame.this.executeDiffCountActionActionPerformed(event);
                }
            });
        }
        return this.executeDiffCount;
    }

    private JButton getBrowseNewRoot() {
        if (this.browseNewRoot == null) {
            this.browseNewRoot = new JButton();
            this.browseNewRoot.setText("\u53c2\u7167...");
            this.browseNewRoot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DiffCountFrame.this.browseNewRootActionActionPerformed(event);
                }
            });
        }
        return this.browseNewRoot;
    }

    private JButton getBrowseOldRoot() {
        if (this.browseOldRoot == null) {
            this.browseOldRoot = new JButton();
            this.browseOldRoot.setText("\u53c2\u7167...");
            this.browseOldRoot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DiffCountFrame.this.browseOldRootActionActionPerformed(event);
                }
            });
        }
        return this.browseOldRoot;
    }

    private JTextField getJTextField1() {
        if (this.newRoot == null) {
            this.newRoot = new JTextField();
            this.newRoot.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }

                public void insertUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }

                public void changedUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }
            });
        }
        return this.newRoot;
    }

    private JTextField getJTextField0() {
        if (this.oldRoot == null) {
            this.oldRoot = new JTextField();
            this.oldRoot.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }

                public void insertUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }

                public void changedUpdate(DocumentEvent e) {
                    DiffCountFrame.this.updateStatus();
                }
            });
        }
        return this.oldRoot;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("\u5909\u66f4\u5f8c\u306e\u30bd\u30fc\u30b9\u30c4\u30ea\u30fc:");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel0() {
        if (this.jLabel0 == null) {
            this.jLabel0 = new JLabel();
            this.jLabel0.setText("\u5909\u66f4\u524d\u306e\u30bd\u30fc\u30b9\u30c4\u30ea\u30fc:");
        }
        return this.jLabel0;
    }

    private static void installLnF() {
        try {
            String lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.windows.WindowsLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        DiffCountFrame.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffCountFrame frame = new DiffCountFrame();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("\u5dee\u5206\u6e2c\u5b9a\u30ab\u30a6\u30f3\u30bf");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    private void browseOldRootActionActionPerformed(ActionEvent event) {
        File file = this.chooseFolder();
        if (file != null) {
            this.oldRoot.setText(file.getAbsolutePath());
            this.updateStatus();
        }
    }

    private void browseNewRootActionActionPerformed(ActionEvent event) {
        File file = this.chooseFolder();
        if (file != null) {
            this.newRoot.setText(file.getAbsolutePath());
            this.updateStatus();
        }
    }

    private File chooseFolder() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void updateStatus() {
        this.executeDiffCount.setEnabled(false);
        String oldRoot = this.oldRoot.getText();
        String newRoot = this.newRoot.getText();
        if (oldRoot.length() != 0 && newRoot.length() != 0) {
            File oldFile = new File(oldRoot);
            File newFile = new File(newRoot);
            if (oldFile.exists() && oldFile.isDirectory() && newFile.exists() && newFile.isDirectory()) {
                this.executeDiffCount.setEnabled(true);
            }
        }
    }

    private void executeDiffCountActionActionPerformed(ActionEvent event) {
        File oldRoot = new File(this.oldRoot.getText());
        File newRoot = new File(this.newRoot.getText());
        DiffFolderResult root = DiffCounter.count(oldRoot, newRoot);
        DiffCountTreeTableModel model = (DiffCountTreeTableModel)this.resultTable.getTreeTableModel();
        model.setRoot(this.wrapToTreeTableModel(root));
    }

    private DefaultMutableTreeTableNode wrapToTreeTableModel(DiffFolderResult folder) {
        DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode(folder);
        for (AbstractDiffResult child : folder.getChildren()) {
            if (child instanceof DiffFolderResult) {
                node.add(this.wrapToTreeTableModel((DiffFolderResult)child));
                continue;
            }
            DefaultMutableTreeTableNode childNode = new DefaultMutableTreeTableNode(child);
            node.add(childNode);
        }
        return node;
    }
}

