/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.format;

import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.format.ResultFormatter;

public class DefaultFormatter
implements ResultFormatter {
    public byte[] format(CountResult[] results) {
        long sumStep = 0L;
        long sumComment = 0L;
        long sumNone = 0L;
        int maxFileLength = this.getFileLength(results);
        StringBuffer sb = new StringBuffer();
        sb.append(this.fillOrCut("\u30d5\u30a1\u30a4\u30eb", maxFileLength));
        sb.append("\u7a2e\u985e  \u30ab\u30c6\u30b4\u30ea            \u5b9f\u884c  \u7a7a\u884c  \uff7a\uff92\uff9d\uff84  \u5408\u8a08  ");
        sb.append("\n");
        sb.append(this.makeHyphen(maxFileLength));
        sb.append("--------------------------------------------------");
        sb.append("\n");
        int i = 0;
        while (i < results.length) {
            CountResult result = results[i];
            if (result.getFileType() == null) {
                sb.append(this.fillOrCut(result.getFileName(), maxFileLength));
                sb.append("\u672a\u5bfe\u5fdc");
                sb.append("\n");
            } else {
                String step = String.valueOf(result.getStep());
                String non = String.valueOf(result.getNon());
                String comment = String.valueOf(result.getComment());
                String sum = String.valueOf(result.getStep() + result.getNon() + result.getComment());
                sb.append(this.fillOrCut(result.getFileName(), maxFileLength));
                sb.append(this.fillOrCut(result.getFileType(), 6));
                sb.append(this.fillOrCut(result.getCategory(), 20));
                sb.append(this.leftFillOrCut(step, 6));
                sb.append(this.leftFillOrCut(non, 6));
                sb.append(this.leftFillOrCut(comment, 6));
                sb.append(this.leftFillOrCut(sum, 6));
                sb.append("\n");
                sumStep += result.getStep();
                sumComment += result.getComment();
                sumNone += result.getNon();
            }
            ++i;
        }
        sb.append(this.makeHyphen(maxFileLength));
        sb.append("--------------------------------------------------");
        sb.append("\n");
        sb.append(this.fillOrCut("\u5408\u8a08", maxFileLength));
        sb.append(this.makeSpace(6));
        sb.append(this.makeSpace(20));
        sb.append(this.leftFillOrCut(String.valueOf(sumStep), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumNone), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumComment), 6));
        sb.append(this.leftFillOrCut(String.valueOf(sumStep + sumNone + sumComment), 6));
        sb.append("\n");
        return sb.toString().getBytes();
    }

    protected int getFileLength(CountResult[] results) {
        int fileLength = 40;
        if (results == null || results.length == 0) {
            return fileLength;
        }
        CountResult[] countResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            int len;
            CountResult result = countResultArray[n2];
            String fileName = result.getFileName();
            if (fileName != null && fileLength < (len = this.getDisplayWidth(fileName))) {
                fileLength = len;
            }
            ++n2;
        }
        return fileLength;
    }

    private int getDisplayWidth(String str) {
        int len = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            len = c <= '\u00ff' || c >= '\uff61' && c <= '\uffdc' || c >= '\uffe8' && c <= '\uffee' ? ++len : (len += 2);
            ++i;
        }
        return len;
    }

    private String makeSpace(int width) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < width) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private String makeHyphen(int width) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < width) {
            sb.append('-');
            ++i;
        }
        return sb.toString();
    }

    private String fillOrCut(String str, int width) {
        int length = this.getDisplayWidth(str);
        if (length == width) {
            return str;
        }
        if (length < width) {
            return String.valueOf(str) + this.makeSpace(width - length);
        }
        return Util.substring(str, width);
    }

    private String leftFillOrCut(String str, int width) {
        int length = Util.getByteLength(str);
        if (length == width) {
            return str;
        }
        if (length < width) {
            return String.valueOf(this.makeSpace(width - length)) + str;
        }
        return Util.substring(str, width);
    }
}

