/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.format;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.stepcounter.CategoryStepDto;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.Util;
import jp.sf.amateras.stepcounter.format.ResultFormatter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.template.FPTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelFormatter
implements ResultFormatter {
    @Override
    public byte[] format(CountResult[] result) {
        try {
            InputStream in = ExcelFormatter.class.getResourceAsStream("ExcelFormatter.xls");
            long totalStep = 0L;
            long totalNone = 0L;
            long totalComment = 0L;
            ArrayList<CategoryStepDto> categories = new ArrayList<CategoryStepDto>();
            CategoryStepDto nonCategory = new CategoryStepDto();
            nonCategory.setCategory("");
            boolean useNonCategory = false;
            CountResult[] countResultArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                CountResult resultDto = countResultArray[n2];
                CategoryStepDto categoryDto = null;
                if (resultDto.getCategory() == null || "".equals(resultDto.getCategory())) {
                    categoryDto = nonCategory;
                    useNonCategory = true;
                } else {
                    categoryDto = ExcelFormatter.getCategoryDto(categories, resultDto.getCategory());
                }
                categoryDto.setStep(categoryDto.getStep() + resultDto.getStep());
                categoryDto.setNone(categoryDto.getNone() + resultDto.getNon());
                categoryDto.setComment(categoryDto.getComment() + resultDto.getComment());
                totalStep += resultDto.getStep();
                totalNone += resultDto.getNon();
                totalComment += resultDto.getComment();
                ++n2;
            }
            if (useNonCategory) {
                categories.add(nonCategory);
            }
            Collections.sort(categories, new Comparator<CategoryStepDto>(){

                @Override
                public int compare(CategoryStepDto o1, CategoryStepDto o2) {
                    if (o1.getCategory().length() == 0 && o2.getCategory().length() == 0) {
                        return 0;
                    }
                    if (o1.getCategory().length() == 0) {
                        return 1;
                    }
                    if (o2.getCategory().length() == 0) {
                        return -1;
                    }
                    return o1.getCategory().compareTo(o2.getCategory());
                }
            });
            countResultArray = result;
            n = result.length;
            n2 = 0;
            while (n2 < n) {
                CountResult r = countResultArray[n2];
                if (r.getCategory() == null) {
                    r.setCategory("");
                }
                if (r.getFileType() == null) {
                    r.setFileType("\u672a\u5bfe\u5fdc");
                }
                ++n2;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("results", result);
            data.put("categories", categories);
            data.put("totalStep", totalStep);
            data.put("totalNone", totalNone);
            data.put("totalComment", totalComment);
            return ExcelFormatter.merge(in, data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] merge(InputStream in, Map<String, Object> data) throws Exception {
        HSSFWorkbook wb;
        FPTemplate template = new FPTemplate();
        try {
            wb = template.process(in, data);
        }
        finally {
            Util.close(in);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wb.write(out);
        return out.toByteArray();
    }

    private static CategoryStepDto getCategoryDto(List<CategoryStepDto> categoryResult, String category) {
        CategoryStepDto categoryDto2;
        for (CategoryStepDto categoryDto2 : categoryResult) {
            if (!categoryDto2.getCategory().equals(category)) continue;
            return categoryDto2;
        }
        categoryDto2 = new CategoryStepDto();
        categoryDto2.setCategory(category);
        categoryResult.add(categoryDto2);
        return categoryDto2;
    }
}

