/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.format.ResultFormatter;

public class JSONFormatter
implements ResultFormatter {
    private static final int[] ESCAPE_CHARS = new int[128];

    static {
        int i = 0;
        while (i < 32) {
            JSONFormatter.ESCAPE_CHARS[i] = -1;
            ++i;
        }
        JSONFormatter.ESCAPE_CHARS[8] = 98;
        JSONFormatter.ESCAPE_CHARS[9] = 116;
        JSONFormatter.ESCAPE_CHARS[10] = 110;
        JSONFormatter.ESCAPE_CHARS[12] = 102;
        JSONFormatter.ESCAPE_CHARS[13] = 114;
        JSONFormatter.ESCAPE_CHARS[34] = 34;
        JSONFormatter.ESCAPE_CHARS[92] = 92;
        JSONFormatter.ESCAPE_CHARS[60] = -2;
        JSONFormatter.ESCAPE_CHARS[62] = -2;
        JSONFormatter.ESCAPE_CHARS[127] = -1;
    }

    public byte[] format(CountResult[] results) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            ((Writer)writer).append("[");
            boolean first = true;
            CountResult[] countResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                CountResult result = countResultArray[n2];
                if (first) {
                    ((Writer)writer).append("\n");
                } else {
                    ((Writer)writer).append(",\n");
                }
                ((Writer)writer).append("\t{ ");
                ((Writer)writer).append("\"name\": \"");
                JSONFormatter.escape(writer, result.getFileName());
                ((Writer)writer).append("\", ");
                if (result.getFileType() == null || result.getFileType().length() == 0) {
                    ((Writer)writer).append("\"type\": \"unknown\"");
                } else {
                    ((Writer)writer).append("\"type\": \"");
                    JSONFormatter.escape(writer, result.getFileType());
                    ((Writer)writer).append("\", ");
                    if (result.getCategory() != null && result.getCategory().length() > 0) {
                        ((Writer)writer).append("\"category\": \"");
                        JSONFormatter.escape(writer, result.getCategory());
                        ((Writer)writer).append("\", ");
                    }
                    long total = result.getStep() + result.getNon() + result.getComment();
                    ((Writer)writer).append("\"step\": ").append(Long.toString(result.getStep())).append(", ");
                    ((Writer)writer).append("\"none\": ").append(Long.toString(result.getNon())).append(", ");
                    ((Writer)writer).append("\"comment\": ").append(Long.toString(result.getComment())).append(", ");
                    ((Writer)writer).append("\"total\": ").append(Long.toString(total)).append(" ");
                }
                ((Writer)writer).append("}");
                first = false;
                ++n2;
            }
            writer.write("\n]\n");
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private static void escape(Writer writer, String text) throws IOException {
        if (text == null) {
            return;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c < ESCAPE_CHARS.length) {
                int x = ESCAPE_CHARS[c];
                if (x == 0) {
                    writer.append(c);
                } else if (x > 0) {
                    writer.append('\\');
                    writer.append((char)x);
                } else if (x == -1) {
                    writer.append("\\u00");
                    writer.append("0123456789ABCDEF".charAt(c / 16));
                    writer.append("0123456789ABCDEF".charAt(c % 16));
                }
            } else {
                writer.append(c);
            }
            ++i;
        }
    }
}

