/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.stepcounter.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jp.sf.amateras.stepcounter.CountResult;
import jp.sf.amateras.stepcounter.format.ResultFormatter;

public class XMLFormatter
implements ResultFormatter {
    private static final char[] ESCAPE_CHARS = new char[128];

    static {
        int i = 0;
        while (i < 32) {
            XMLFormatter.ESCAPE_CHARS[i] = '\u0001';
            ++i;
        }
        XMLFormatter.ESCAPE_CHARS[60] = 2;
        XMLFormatter.ESCAPE_CHARS[62] = 3;
        XMLFormatter.ESCAPE_CHARS[38] = 4;
        XMLFormatter.ESCAPE_CHARS[34] = 5;
        XMLFormatter.ESCAPE_CHARS[127] = '\u0001';
    }

    public byte[] format(CountResult[] results) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ((Writer)writer).append("<stepcounter>\n");
            CountResult[] countResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                CountResult result = countResultArray[n2];
                ((Writer)writer).append("\t<file ");
                ((Writer)writer).append("name=\"");
                XMLFormatter.escape(writer, result.getFileName());
                ((Writer)writer).append("\" ");
                if (result.getFileType() == null || result.getFileType().length() == 0) {
                    ((Writer)writer).append("type=\"unknown\" ");
                } else {
                    ((Writer)writer).append("type=\"");
                    XMLFormatter.escape(writer, result.getFileType());
                    ((Writer)writer).append("\" ");
                    if (result.getCategory() != null && result.getCategory().length() > 0) {
                        ((Writer)writer).append("category=\"");
                        XMLFormatter.escape(writer, result.getCategory());
                        ((Writer)writer).append("\" ");
                    }
                    long total = result.getStep() + result.getNon() + result.getComment();
                    ((Writer)writer).append("step=\"").append(Long.toString(result.getStep())).append("\" ");
                    ((Writer)writer).append("none=\"").append(Long.toString(result.getNon())).append("\" ");
                    ((Writer)writer).append("comment=\"").append(Long.toString(result.getComment())).append("\" ");
                    ((Writer)writer).append("total=\"").append(Long.toString(total)).append("\" ");
                }
                ((Writer)writer).append("/>\n");
                ++n2;
            }
            writer.write("</stepcounter>\n");
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private static void escape(Writer writer, String text) throws IOException {
        if (text == null) {
            return;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c < ESCAPE_CHARS.length) {
                switch (ESCAPE_CHARS[c]) {
                    case '\u0001': {
                        writer.append("&#").append(Integer.toString(c)).append(";");
                        break;
                    }
                    case '\u0002': {
                        writer.append("&lt;");
                        break;
                    }
                    case '\u0003': {
                        writer.append("&gt;");
                        break;
                    }
                    case '\u0004': {
                        writer.append("&amp;");
                        break;
                    }
                    case '\u0005': {
                        writer.append("&quot;");
                        break;
                    }
                    default: {
                        writer.append(c);
                        break;
                    }
                }
            } else {
                writer.append(c);
            }
            ++i;
        }
    }
}

