/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class GenericCell
extends AbstractCell {
    public GenericCell(CellWrapper cell) {
        super(cell);
    }

    protected void mergeImpl(FPContext context, HSSFCell out) {
        HSSFCell templateCell = this.cell.getHSSFCell();
        Object cellValue = this.getCellValue();
        int cellType = templateCell.getCellType();
        if (cellType == 2) {
            out.setCellFormula((String)cellValue);
        } else if (cellType == 5) {
            out.setCellErrorValue((Byte)cellValue);
        } else if (cellValue instanceof Date) {
            out.setCellValue((Date)cellValue);
            out.setCellType(0);
        } else if (cellValue instanceof String) {
            out.setCellValue(new HSSFRichTextString((String)cellValue));
            out.setCellType(1);
        } else if (cellValue instanceof Boolean) {
            out.setCellValue((Boolean)cellValue);
            out.setCellType(4);
        } else if (this.isNumber(cellValue)) {
            out.setCellValue(Double.valueOf(cellValue.toString()));
            out.setCellType(0);
        }
    }

    private boolean isNumber(Object value) {
        if (value == null || value instanceof String) {
            return false;
        }
        try {
            Double.valueOf(value.toString());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

