/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.Row;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.util.IteratorUtil;
import org.seasar.fisshplate.util.OgnlUtil;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class HorizontalIteratorBlock
extends AbstractBlock {
    private String varName;
    private String iteratorName;
    private String indexName;
    private int startCellIndex;
    private RowWrapper row;

    public HorizontalIteratorBlock(String varName, String iteratorName, String indexName, CellWrapper cell) {
        this.varName = varName;
        this.iteratorName = iteratorName;
        this.startCellIndex = cell.getCellIndex();
        this.row = cell.getRow();
        this.indexName = indexName == null || "".equals(indexName.trim()) ? "index" : indexName;
    }

    public void merge(FPContext context) throws FPMergeException {
        Map data = context.getData();
        Object o = OgnlUtil.getValue(this.iteratorName, data);
        Iterator ite = IteratorUtil.getIterator(o, this.iteratorName, this.row);
        this.mergeIteratively(context, ite, data);
    }

    private void mergeIteratively(FPContext context, Iterator ite, Map data) throws FPMergeException {
        int index = 0;
        int startRowNum = context.getCurrentRowNum();
        int startCell = this.startCellIndex;
        int maxCellNum = this.getMaxCellElementListSize() - this.startCellIndex;
        this.mergeNoIterationBlock(context);
        while (ite.hasNext()) {
            Object var = ite.next();
            data.put(this.varName, var);
            data.put(this.indexName, new Integer(index));
            ++index;
            context.moveCurrentRowTo(startRowNum);
            this.mergeBlock(context, startCell);
            startCell += maxCellNum;
        }
    }

    protected void mergeBlock(FPContext context, int startCell) throws FPMergeException {
        for (int i = 0; i < this.childList.size(); ++i) {
            TemplateElement elem = (TemplateElement)this.childList.get(i);
            if (elem instanceof Row) {
                context.moveCurrentCellTo((short)startCell);
                this.mergeRow(context, (Row)elem);
                continue;
            }
            elem.merge(context);
        }
    }

    private int getMaxCellElementListSize() {
        int max = 0;
        for (int i = 0; i < this.childList.size(); ++i) {
            TemplateElement elem = (TemplateElement)this.childList.get(i);
            if (!(elem instanceof Row)) continue;
            int listSize = ((Row)elem).getCellElementList().size();
            max = max > listSize ? max : listSize;
        }
        return max;
    }

    private void mergeRow(FPContext context, Row row) throws FPMergeException {
        HSSFRow outRow = context.getCurrentRow();
        outRow.setHeight(row.getRowHeight());
        Map data = context.getData();
        data.put("rownum", new Integer(context.getCurrentRowNum() + 1));
        for (int i = 0; i < row.getCellElementList().size(); ++i) {
            if (i < this.startCellIndex) continue;
            this.adjustColumnWidth(context, (short)i);
            TemplateElement elem = (TemplateElement)row.getCellElementList().get(i);
            elem.merge(context);
        }
        context.nextRow();
    }

    private void adjustColumnWidth(FPContext context, int column) {
        int cellWidth = this.row.getSheet().getHSSFSheet().getColumnWidth(column);
        context.getOutSheet().setColumnWidth(context.getCurrentCellNum(), cellWidth);
    }

    private void mergeNoIterationBlock(FPContext context) throws FPMergeException {
        for (int i = 0; i < this.childList.size(); ++i) {
            TemplateElement elem = (TemplateElement)this.childList.get(i);
            if (elem instanceof Row) {
                this.mergeNoIterationRow(context, (Row)elem);
                continue;
            }
            elem.merge(context);
        }
    }

    private void mergeNoIterationRow(FPContext context, Row row) throws FPMergeException {
        HSSFRow outRow = context.createCurrentRow();
        outRow.setHeight(row.getRowHeight());
        Map data = context.getData();
        data.put("rownum", new Integer(context.getCurrentRowNum() + 1));
        for (int i = 0; i < row.getCellElementList().size() && i < this.startCellIndex; ++i) {
            TemplateElement elem = (TemplateElement)row.getCellElementList().get(i);
            elem.merge(context);
        }
        context.nextRow();
    }
}

