/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.context.PageContext;
import org.seasar.fisshplate.core.element.IteratorBlock;
import org.seasar.fisshplate.core.element.Root;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;

public class PageBreak
implements TemplateElement {
    private Root root;

    public PageBreak(Root root) {
        this.root = root;
    }

    public void merge(FPContext context) throws FPMergeException {
        this.writeFooter(context);
        this.pageBreak(context);
        this.pageCountUp(context);
        context.setShouldHeaderOut(true);
        context.setShouldFooterOut(false);
        if (context.inIteratorBlock()) {
            IteratorBlock currentIterator = context.getCurrentIterator();
            currentIterator.initLineNumPerPage();
        }
    }

    private void pageCountUp(FPContext context) {
        ((PageContext)context.getData().get("page")).addPageNum();
    }

    private void writeFooter(FPContext context) throws FPMergeException {
        TemplateElement footer = this.root.getPageFooter();
        footer.merge(context);
    }

    private void pageBreak(FPContext context) {
        HSSFSheet sheet = context.getOutSheet();
        int currentRowNum = context.getCurrentRowNum();
        sheet.setRowBreak(currentRowNum - 1);
    }
}

