/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.NullElement;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;

public class Root
implements TemplateElement {
    private TemplateElement pageHeaderBlock = new NullElement();
    private List bodyElementList = new ArrayList();
    private TemplateElement pageFooterBlock = new NullElement();

    public void merge(FPContext context) throws FPMergeException {
        context.setShouldHeaderOut(false);
        this.pageHeaderBlock.merge(context);
        this.mergeBodyElement(context);
        if (context.shouldFooterOut()) {
            this.pageFooterBlock.merge(context);
        }
        this.removeUnwantedRows(context);
    }

    private void mergeBodyElement(FPContext context) throws FPMergeException {
        for (int i = 0; i < this.bodyElementList.size(); ++i) {
            TemplateElement elem = (TemplateElement)this.bodyElementList.get(i);
            elem.merge(context);
        }
    }

    private void removeUnwantedRows(FPContext context) {
        HSSFSheet outSheet = context.getOutSheet();
        int currentRowNum = context.getCurrentRowNum();
        int lastRowNum = outSheet.getLastRowNum();
        for (int i = currentRowNum; i <= lastRowNum; ++i) {
            outSheet.removeRow(outSheet.getRow(i));
        }
    }

    public TemplateElement getPageHeader() {
        return this.pageHeaderBlock;
    }

    public void setPageHeader(TemplateElement pageHeader) {
        this.pageHeaderBlock = pageHeader;
    }

    public TemplateElement getPageFooter() {
        return this.pageFooterBlock;
    }

    public void setPageFooter(TemplateElement pageFooter) {
        this.pageFooterBlock = pageFooter;
    }

    public void addBody(TemplateElement element) {
        this.bodyElementList.add(element);
    }

    public List getBodyElementList() {
        return this.bodyElementList;
    }
}

