/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.util.OgnlUtil;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class Var
implements TemplateElement {
    private String[] expressions;
    private RowWrapper row;
    private Pattern patDeclr = Pattern.compile("([^=\\s]+)\\s*(=\\s*[^=\\s]+)?");

    public Var(String expression, RowWrapper row) {
        this.expressions = expression.split("\\s*,\\s*");
        this.row = row;
    }

    public void merge(FPContext context) throws FPMergeException {
        Map data = context.getData();
        for (int i = 0; i < this.expressions.length; ++i) {
            String expression = this.expressions[i].trim();
            this.evalExpression(data, expression);
        }
    }

    private void evalExpression(Map data, String expression) throws FPMergeException {
        Matcher mat = this.patDeclr.matcher(expression);
        if (!mat.find()) {
            this.throwMergeException("EFP00011", expression, this.row);
        }
        String varName = mat.group(1);
        this.assignVariable(data, varName);
        if (mat.group(2) != null) {
            this.initializeVariable(data, expression);
        }
    }

    private void assignVariable(Map data, String varName) throws FPMergeException {
        if (data.containsKey(varName)) {
            this.throwMergeException("EFP00010", varName, this.row);
        }
        data.put(varName, "");
    }

    private void initializeVariable(Map data, String expression) throws FPMergeException {
        try {
            OgnlUtil.getValue(expression, data);
        }
        catch (RuntimeException e) {
            this.throwMergeException("EFP00011", expression, this.row);
        }
    }

    private void throwMergeException(String messageId, String var, RowWrapper row) throws FPMergeException {
        throw new FPMergeException(messageId, new Object[]{var}, row);
    }
}

