/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.IfBlock;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class IfBlockParser
implements RowParser {
    private static final Pattern patIf = Pattern.compile("^\\s*#if\\s*(.+)");

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = patIf.matcher(value);
        if (!mat.find()) {
            return false;
        }
        String condition = mat.group(1);
        IfBlock block = new IfBlock(condition);
        parser.addBlockElement(block);
        return true;
    }
}

