/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.Var;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class VarParser
implements RowParser {
    private static final Pattern patVar = Pattern.compile("#var\\s+(.+)");

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = patVar.matcher(value);
        if (!mat.find()) {
            return false;
        }
        RowWrapper row = cell.getRow();
        String vars = mat.group(1);
        Var elem = new Var(vars, row);
        parser.addTemplateElement(elem);
        return true;
    }
}

