/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.preview;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.core.BindVariable;
import org.seasar.fisshplate.exception.FPPreviewException;
import org.seasar.fisshplate.preview.FPMapData;
import org.seasar.fisshplate.util.StringUtil;
import org.seasar.fisshplate.wrapper.SheetWrapper;
import org.seasar.fisshplate.wrapper.WorkbookWrapper;

public class MapBuilder {
    private static final String ROOT_SHEET_NAME = "root";

    public Map buildMapFrom(HSSFWorkbook wb) {
        WorkbookWrapper workbook = new WorkbookWrapper(wb);
        SheetWrapper sheet = workbook.getSheetByName(ROOT_SHEET_NAME);
        FPMapData root = new FPMapData(sheet, ROOT_SHEET_NAME);
        this.buildRootMapData(workbook, root);
        return (Map)root.buildData();
    }

    private void buildRootMapData(WorkbookWrapper workbook, FPMapData root) {
        for (int i = 0; i < workbook.getSheetCount(); ++i) {
            SheetWrapper sheet = workbook.getSheetAt(i);
            String keyName = this.getKeyNameFrom(sheet);
            if (ROOT_SHEET_NAME.equals(keyName)) continue;
            this.buildMapData(root, sheet, keyName);
        }
    }

    private String getKeyNameFrom(SheetWrapper sheet) {
        String col = sheet.getRow(0).getCell(0).getStringValue();
        if (!StringUtil.isEmpty(col) && Pattern.matches("\\$\\{[^\\$\\{\\}]+\\}", col)) {
            sheet.removeRow(0);
            BindVariable var = new BindVariable(col);
            return var.getName();
        }
        return sheet.getSheetName();
    }

    private void buildMapData(FPMapData parent, SheetWrapper sheet, String keyName) {
        int idx = keyName.indexOf(35);
        if (idx == -1) {
            parent.addChild(sheet, keyName);
        } else {
            this.buildMapDataComposition(parent, sheet, keyName, idx);
        }
    }

    private void buildMapDataComposition(FPMapData grandParent, SheetWrapper sheet, String keyName, int idx) {
        String selfKeyName = keyName.substring(idx + 1);
        String parentKeyName = keyName.substring(0, idx);
        FPMapData parent = grandParent.getChildByKey(parentKeyName);
        if (parent == null) {
            throw new FPPreviewException("EFP00009", new Object[]{parentKeyName});
        }
        this.buildMapData(parent, sheet, selfKeyName);
    }
}

