/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.util;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;

public class FPPoiUtil {
    private FPPoiUtil() {
    }

    public static Object getCellValueAsObject(HSSFCell hssfCell) {
        if (hssfCell == null) {
            return null;
        }
        int cellType = hssfCell.getCellType();
        Object ret = null;
        switch (cellType) {
            case 0: {
                ret = FPPoiUtil.getValueFromNumericCell(hssfCell);
                break;
            }
            case 1: {
                ret = hssfCell.getRichStringCellValue().getString();
                break;
            }
            case 4: {
                ret = hssfCell.getBooleanCellValue();
                break;
            }
            case 2: {
                ret = hssfCell.getCellFormula();
                break;
            }
            case 5: {
                ret = new Byte(hssfCell.getErrorCellValue());
                break;
            }
            case 3: {
                break;
            }
            default: {
                return null;
            }
        }
        return ret;
    }

    private static Object getValueFromNumericCell(HSSFCell cell) {
        String str = cell.toString();
        if (str.matches("\\d+-.+-\\d+")) {
            return cell.getDateCellValue();
        }
        return new Double(cell.getNumericCellValue());
    }

    public static String getStringValue(HSSFCell hssfCell) {
        if (hssfCell == null) {
            return null;
        }
        HSSFRichTextString richVal = hssfCell.getRichStringCellValue();
        if (richVal == null) {
            return null;
        }
        return richVal.getString();
    }
}

