/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.SheetWrapper;

public class RowWrapper {
    private HSSFRow hssfRow;
    private SheetWrapper sheet;
    private List cellList = new ArrayList();

    public RowWrapper(HSSFRow row, SheetWrapper sheet) {
        this.sheet = sheet;
        this.hssfRow = row;
        if (row != null) {
            this.addCellsToList(row);
        }
    }

    private void addCellsToList(HSSFRow row) {
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            this.cellList.add(new CellWrapper(row.getCell(i), this));
        }
    }

    public boolean isNullRow() {
        return this.hssfRow == null;
    }

    public HSSFRow getHSSFRow() {
        return this.hssfRow;
    }

    public SheetWrapper getSheet() {
        return this.sheet;
    }

    public CellWrapper getCell(int index) {
        if (index + 1 > this.cellList.size()) {
            return null;
        }
        return (CellWrapper)this.cellList.get(index);
    }

    public int getCellCount() {
        return this.cellList.size();
    }
}

