/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2011 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2011 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
package blanco.eclipseast2cg.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;

public class BlancoEclipseASTUtil {
    public static String getSimpleNameIdentifier(final TagElement tag) {
        for (Object fragment : tag.fragments()) {
            if (fragment instanceof SimpleName) {
                SimpleName name = (SimpleName) fragment;
                return name.getIdentifier();

            } else if (fragment instanceof TextElement) {
                // 何もしません
            } else {
                // 何もしません
            }
        }
        return null;
    }

    public static List<String> getText(final TagElement tag) {
        final List<String> result = new ArrayList<String>();
        for (Object fragment : tag.fragments()) {
            if (fragment instanceof SimpleName) {
                // 何もしません
            } else if (fragment instanceof TextElement) {
                final TextElement name = (TextElement) fragment;
                result.add(name.getText());
            } else {
                result.add(fragment.toString());
            }
        }

        return result;
    }

    public static String list2String(final List<String> arg) {
        final StringBuffer result = new StringBuffer();
        for (String val : arg) {
            result.append(val);
        }
        return result.toString();
    }
}
