/*
 * このクラスは 'AbstractBlancoFileManagerFileAttrInfoDao' の具象クラスとして blanco Framework によって自動生成されました。
 */
package blanco.filemanager.db.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import blanco.filemanager.db.query.Sbfm0301Iterator;
import blanco.filemanager.db.query.Sbfm0302Iterator;
import blanco.filemanager.dbaccessor.query.BfmFileAttrInfoI01Invoker;
import blanco.filemanager.dbaccessor.query.BfmFileAttrInfoS01Iterator;
import blanco.filemanager.file.BlancoFileManagerFileAttrInfo;
import blanco.fw.BlancoGeneratedBy;

/**
 */
@BlancoGeneratedBy(name = "Blanco2g")
public class BlancoFileManagerFileAttrInfoDao extends AbstractBlancoFileManagerFileAttrInfoDao {
    /**
     * 指定されたファイルIDのファイル属性情報を取得します。
     *
     * @param conn
     * @param fileAttrId
     * @return
     * @throws SQLException
     */
    public BlancoFileManagerFileAttrInfo getFileAttrInfo(Connection conn, int fileAttrId) throws SQLException {
        blanco.filemanager.file.BlancoFileManagerFileAttrInfo autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final BfmFileAttrInfoS01Iterator iteAttr = new BfmFileAttrInfoS01Iterator(conn);
        try {
            autoValMethodResult = super.getFileAttrInfo(conn, iteAttr, fileAttrId);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteAttr.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 指定されたファイルIDにひもづく最後の(すなはちファイル属性IDがいちばん大きな)ファイル属性情報を取得します。
     *
     * @param conn
     * @param fileId
     * @return  あればファイルID。なければ -1。
     * @throws SQLException
     */
    public BlancoFileManagerFileAttrInfo getLastFileAttrInfo(Connection conn, int fileId) throws SQLException {
        blanco.filemanager.file.BlancoFileManagerFileAttrInfo autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0302Iterator iteAttr = new Sbfm0302Iterator(conn);
        try {
            autoValMethodResult = super.getLastFileAttrInfo(conn, iteAttr, fileId);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteAttr.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 次のファイル説明IDを採番します。
     *
     * @param conn
     * @return
     * @throws SQLException
     */
    public int getNextFileAttrId(Connection conn) throws SQLException {
        int autoValMethodResult;
        // [@BlancoInject] Inject DAO object.
        final Sbfm0301Iterator iteMax = new Sbfm0301Iterator(conn);
        try {
            autoValMethodResult = super.getNextFileAttrId(conn, iteMax);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                iteMax.close();
            } catch (SQLException exIgnore) {
            }
        }
        return autoValMethodResult;
    }

    /**
     * 新たなデータをINESRTします。
     *
     * @param conn
     * @param fileAttr
     * @param now
     * @throws SQLException
     */
    public void insertFileAttrInfo(Connection conn, BlancoFileManagerFileAttrInfo fileAttr, Date now) throws SQLException {
        // [@BlancoInject] Inject DAO object.
        final BfmFileAttrInfoI01Invoker invAttr = new BfmFileAttrInfoI01Invoker(conn);
        try {
            super.insertFileAttrInfo(conn, fileAttr, invAttr, now);
        } finally {
            // [@BlancoInject] Close DAO object.
            try {
                invAttr.close();
            } catch (SQLException exIgnore) {
            }
        }
    }
}
